#include "stm32f103c8t6.h"
#include "mbed.h"
#include "USBSerial.h"

USBSerial usbSerial(0x1f00, 0x2012, 0x0001,  false);    // connection is not blocked when USB is not plugged in
//Serial    pc(PA_2, PA_3);


//#define S5851A 0x48
#define ADDR        ((0x48)<<1)   //  address

//I2C i2c(I2C_SDA, I2C_SCL);
I2C i2c(PB_7, PB_6); //103


int     tempval;        //温度
char    data_read[6];   //i2cバッファー
int     n10;            //10の桁

int main() {
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)

    //usbSerial.printf("\r\n103\r\n");

    while(1) {

        //初期化
        //set address 0
        i2c.write(ADDR, "\000", 1); //addres 0

        //温度の読み込み
        // Read temperature register
        i2c.read(ADDR, data_read,1,false);

        //温度の保存
        // Calculate temperature value in Celcius
        tempval =  data_read[0];

        //tempval = 12; //debug

        //計算
        // Calculation temp
        n10 = tempval/10;                 //10の桁
        tempval = tempval - ( n10 * 10 ); //1の桁

        //液晶に出力
        // Display result
        data_read[0] = '0' + n10;
        data_read[1] = '0' + tempval;
        data_read[2] = '\r';
        data_read[3] = '\n';
        data_read[4] = 0;

        //温度の出力
        //puts(data_read); //010
        //pc.printf(data_read); //767
        usbSerial.printf(data_read); //103

        //1秒待つ
        wait_ms(1000);
        
    }//while
    
}//main

