#include "mbed.h"
#include "SSD1306.h"

#define ADDR_OLED       (0x3c<<1) //  address
//#define ADDR_OLED     (0x3d<<1) //  address
#define ADDR        (0xD0)   //  address

//I2C i2c(I2C_SDA, I2C_SCL);
I2C i2c(PB_7, PB_6); // STM32F103C8

// Host PC Communication channels
//Serial pc(USBTX, USBRX); // tx, rx
Serial pc(PA_9, PA_10); // tx, rx 103

// Instantiate OLED
SSD1306 oled(i2c, ADDR_OLED);

int ii; //ループカウンター
int jj; //ループカウンター
int cursor1; //文字カウンター

char    data_read[8];   //i2cバッファー

char ch_hex_a_b[4];
char *ch_hex_a(int l_num)
{
    ch_hex_a_b[0] = '0' + (l_num >> 4);
    ch_hex_a_b[1] = '0' + (l_num & 0xf);
    ch_hex_a_b[2] = '.';
    ch_hex_a_b[3] = 0;
    return(ch_hex_a_b);
}

void i2c_oled_w(char *s)
{
    ii=0;
    while(1){
        if(s[ii] == 0) break;
        //                y   x
        oled.writeBigChar(0, cursor1*16,s[ii]);
        cursor1=cursor1 + 1;
        ii=ii+1;
    } //for
} //i2c_oled_w

int main() {       
    pc.baud(9600);    
    //oled.writeString(0, 0, "Hello World !");  
        
    char n1_8[] = "12345678";
    
    ii=0;
    for(jj=0;jj<8;jj++){
        //                y   x
        oled.writeBigChar(0, ii*16,n1_8[jj]);
        ii = ii + 1;
    } //for
    pc.printf("Printed something\r");    
    wait_ms(500);

    //for(ii=0;ii<8;ii++){
    //    oled.writeString(ii, 0, "Hello World !"); 
    //}
    //wait_ms(1000);

    while(1){
 
        //液晶のクリア
        cursor1 = 0;      
        
        //時間の読み込み
        i2c.write(ADDR, "\000", 1);
        i2c.read(ADDR | 1, data_read, 7);

        //画面に表示
        i2c_oled_w(ch_hex_a(data_read[2]));
        i2c_oled_w(ch_hex_a(data_read[1]));
        ch_hex_a(data_read[0]);ch_hex_a_b[2]=0;
        i2c_oled_w(ch_hex_a_b);

        wait_ms(1000);  
        
    } //while
}
