#include "mbed.h"

//#define S5851A 0x48
#define ADDR        ((0x48)<<1) //  address
#define ADDR_LCD    (0x7C)      //  address

//I2C i2c(I2C_SDA, I2C_SCL); //767 303
//I2C i2c(dp5, dp27); //1114
I2C i2c(PA_10, PA_9); //010

//10の割り算 0から1028までは、正しい。主に0から999
#define DVI10(n) ((n*205)>>11)

int     tempval;        //温度
char    data_read[6];   //i2cバッファー
int     n10;            //10の桁
int     ii;             //ループカウンター

char INIT_com[]={0x0,0x38,
0x0,0x39,
0x0,0x4,
0x0,0x14,
0x0,0x70,
0x0,0x56,
0x0,0x6C,
0x0,0x38,
0x0,0xC,
0x0,0x1,
0x40,0x41};

char INIT_cls[]={0x0,0x1};

int main()
{

    //液晶の初期化
    for(ii=0;ii<11;ii++){
        i2c.write(ADDR_LCD, &INIT_com[ii*2], 2);
        wait_ms(2);
    } //for

    while (1) {

        //液晶のクリア
        i2c.write(ADDR_LCD,INIT_cls,2);
        wait_ms(2);

        //初期化
        //set address 0
        i2c.write(ADDR, "\000", 1); //addres 0

        //温度の読み込み
        // Read temperature register
        i2c.read(ADDR, data_read,1,false);

        //温度の保存
        // Calculate temperature value in Celcius
        tempval =  data_read[0];

        //tempval = 12; //debug

        //計算
        // Calculation temp
        n10 = DVI10(tempval);             //10の桁
        tempval = tempval - ( n10 * 10 ); //1の桁

        //液晶に出力
        // Display result
        data_read[0] = '@';
        data_read[1] = '0' + n10;
        data_read[2] = '0' + tempval;
        //data_read[3] = '\r';
        //data_read[4] = '\n';
        data_read[3] = 0;
        i2c.write(ADDR_LCD, data_read ,3);

        //1秒待つ
        wait_ms(1000);

    }//while

}//main

//容量削減
void error(const char* format, ...){}
