#include "mbed.h"

//10の割り算 0から1028までは、正しい。主に0から999
#define DVI10(n) ((n*205)>>11)

//16ビットadcの4ビットの変換テーブル
#define ADC4BIT { 0   , 62 ,125 ,187 ,250 ,312 ,375 ,437 ,500 ,562 ,625 ,687 ,750 ,812 ,875 ,937 }

//AnalogIn adc_vbat(A3); //PA_4

#define ADDR        (0xD0)   //  address
#define ADDR_LCD    (0x7C)   //  address

//I2C i2c(I2C_SDA, I2C_SCL); //767
//I2C i2c(dp5, dp27); //1114
I2C i2c(PA_10, PA_9); //010

char    data_read[8];   //i2cバッファー

char INIT_com[]={0x0,0x38,
0x0,0x39,
0x0,0x4,
0x0,0x14,
0x0,0x70,
0x0,0x56,
0x0,0x6C,
0x0,0x38,
0x0,0xC,
0x0,0x1,
0x40,0x41};

char INIT_cls[]={0x0,0x1};

char ch_hex_a_b[5];
char *ch_hex_a(int l_num)
{
    int a,b,c;

    b=DVI10(l_num);
    c=l_num-(b*10);
    l_num=b;
    a=DVI10(l_num);
    b=l_num-(a*10);

    ch_hex_a_b[0] = '@';
    ch_hex_a_b[1] = '0' + a;
    ch_hex_a_b[2] = '0' + b;
    ch_hex_a_b[3] = '0' + c;
    ch_hex_a_b[4] = 0;

    return(ch_hex_a_b);
}

int ii;     //ループカウンタ

int main()
{
    //printf("767\r\n"); //767
    //液晶の初期化
    for(ii=0;ii<11;ii++){
        i2c.write(ADDR_LCD, &INIT_com[ii*2], 2);wait_ms(2);
    } //for

    i2c.write(ADDR, "\230", 1); //16bit 15sps PGA x1

//    int p,s; //767
    int s;   //101
    
//    float Volts;
//    float Vref = 2.048 ;
    
    short bit4[]=ADC4BIT;
    
    while (1) {
        //液晶のクリア
        i2c.write(ADDR_LCD,INIT_cls,2);wait_ms(2);

//    //adcの読み込み
//        s = (adc_vbat.read_u16()>>4);
//
//    //  (4096*165)/2048=330 電圧の100倍に変換
//    //s = 13;
//    p = (s*165) >> 11; 

        //データの読み込み
        i2c.read(ADDR | 1, data_read, 2);
        
        s = (data_read[0] * 256 ) + data_read[1];
        //s = 32767;
//        printf("-s=%d\r\n",s); //767
//        printf(" h=%d\r\n",data_read[0]);
//        printf(" l=%d\r\n",data_read[1]);

//        Volts = s * Vref / 32767.0f ;
//        printf(" f=%f\r\n",Volts );

//        p = ( (s >> 4) * 1000 )  + (bit4[ s & 0xf ]) ;
//        printf(" q= %d\r\n",p); //767

//s=(65536/2/2/2)+1;

ii=(s >> 4);
if     ( ii >= 2000 ) { ii = ii - 2000; /*printf("2.\n\r");*/   i2c.write(ADDR_LCD,"@2.",3); }
else if( ii >= 1000 ) { ii = ii - 1000; /*printf("1.\n\r");*/   i2c.write(ADDR_LCD,"@1.",3); }
else                  {                 /*printf("0.\n\r");*/   i2c.write(ADDR_LCD,"@0.",3); }

//printf(" o=%s\r\n",ch_hex_a( ii )                );
i2c.write(ADDR_LCD, ch_hex_a( ii ) ,4);

//printf(" o=%s\r\n",ch_hex_a( (bit4[ s & 0xf ]) ) );
i2c.write(ADDR_LCD,ch_hex_a( ( (int)bit4[ s & 0xf ]))  ,4);

//        // 32768/(163.84/2)=400 luxに変換
//        p=( ((s>>5)*6)  + (s>>7)  ) >> 4;
//        //printf(" p=%d\r\n",p); //767
//        
//        i2c.write(ADDR_LCD, ch_hex_a( p ) ,4);

        wait_ms(1000);
    }//while

}//main

void error(const char* format, ...){}
