#include "mbed.h"

#define ADDR        (0xD0)   //  address
#define ADDR_LCD    (0x7C)      //  address

//I2C i2c(I2C_SDA, I2C_SCL); //767
//I2C i2c(dp5, dp27); //1114
I2C i2c(PA_10, PA_9); //010

char    data_read[8];   //i2cバッファー

char INIT_com[]={0x0,0x38,
0x0,0x39,
0x0,0x4,
0x0,0x14,
0x0,0x70,
0x0,0x56,
0x0,0x6C,
0x0,0x38,
0x0,0xC,
0x0,0x1,
0x40,0x41,0x99,0x99};

char INIT_cls[]={0x0,0x1};

char ch_hex_a_b[5];
char *ch_hex_a(int l_num)
{
    ch_hex_a_b[0] = '@';
    ch_hex_a_b[1] = '0' + (l_num >> 4);
    ch_hex_a_b[2] = '0' + (l_num & 0xf);
    ch_hex_a_b[3] = ':';
    ch_hex_a_b[4] = 0;
    return(ch_hex_a_b);
}

int ii;     //ループカウンタ

int main()
{
    //液晶の初期化
    for(ii=0;ii<11;ii++){
        i2c.write(ADDR_LCD, &INIT_com[ii*2], 2);wait_ms(2);
    } //for
 
    while (1) {
        //液晶のクリア
        i2c.write(ADDR_LCD,INIT_cls,2);wait_ms(2);
        
        //時間の読み込み
        i2c.write(ADDR, "\000", 1);
        i2c.read(ADDR | 1, data_read, 7);
       
        i2c.write(ADDR_LCD, ch_hex_a(data_read[2]) ,4); wait_ms(1);
        i2c.write(ADDR_LCD, ch_hex_a(data_read[1]) ,4); wait_ms(1);
        i2c.write(ADDR_LCD, ch_hex_a(data_read[0]) ,4);

        wait_ms(1000);
    }//while
 
}//main
