#include "mbed.h"

//*          *****  *****  
//*         *       *    * 
//*         ******  *    *
//*         *       *    *
//*         *       *    *
//********   *****  *****

#define swclk1  PA_5    //A4
#define swdio1  PA_7    //A6
#define en1     PA_4    //A3

DigitalOut swdclk(swclk1);
DigitalOut swdio(swdio1);
DigitalOut en(en1);

#define s60()   for(ii=0;ii<60;ii++)wait_ms(1000);

char seg[32] = {
   0x00 , //0 @ -> ' '
   0x77 , //1 A  o
   0x7c , //2 B     　combined use "6"
   0x39 , //3 C
   0x5e , //4 D
   0x79 , //5 E  o
   0x71 , //6 F
   0x3d , //7 G
             
   0x76 , //8 H  o
   0x06 , //9 I    　combined use "1"
   0x1e , //10 J
   0x75 , //11 K 
   0x38 , //12 L  o
   0x15 , //13 M
   0x37 , //14 N  o
   0x3f , //15 O  o　combined use "0"
              
   0x73  , //16 P
   0x67  , //17 Q　combined use "9"
   0x50  , //18 R
   0x6d  , //19 S　combined use "5"
   0x78  , //20 T
   0x3e  , //21 U
   0x1c  , //22 V
   0x2a  , //23 W  o
   0x64  , //24 X
               
   0x6e  , //25 Y
   0x5b  , //26 Z　combined use "2"
   0x4f  , //27 [  --> "3"
   0x66  , //28 \  --> "4"
   0x27  , //29 ]  --> "7"
   0x7f  , //26 ^  --> "8"
   0x08    //31 _
};

//             12345678   12345678   12345678   12345678
char b8[8] = {0b10000000,0b01000000,0b00100000,0b00010000,
              0b00001000,0b00000100,0b00000010,0b00000001 };

void seg1(char v)
{
    v=seg[v-64];
    for(int jj=0;jj<8;jj++){
        if( (v & b8[jj]) == 0 ){
                swdio=0; //ビットが0
        } else {
                swdio=1; //ビットが1 
        }//endif
        swdclk=1;swdclk=0; //clk
    }//for
    en=1;
    en=0;       
}//seg1

int main() {
    
    int ii; //ループカウンター
    
    en=0;
    swdclk=0;
        
    //0分
    seg1('O');
    s60();  
    
    //1分
    seg1('I');
    s60();
    
    //2分
    seg1('Z');
    s60();
    
    //3分
    seg1('[');
    
    while(1){} //無限ループ
    
}//main
