#include "mbed.h"

#define ADDR        (0x39<<1)   //  address
#define ADDR_LCD    (0x7C)      //  address

//I2C i2c(I2C_SDA, I2C_SCL); //767
//I2C i2c(dp5, dp27); //1114
I2C i2c(PA_10, PA_9); //010

int     tempval;        //温度
char    data_read[2];   //i2cバッファー
int     ii;             //ループカウンター
int     p_val;          //戻り値

char INIT_com[]={0x0,0x38,
0x0,0x39,
0x0,0x4,
0x0,0x14,
0x0,0x70,
0x0,0x56,
0x0,0x6C,
0x0,0x38,
0x0,0xC,
0x0,0x1,
0x40,0x41,0x99,0x99};

char INIT_cls[]={0x0,0x1};

int main()
{
 
    //液晶の初期化
    for(ii=0;ii<11;ii++){
        p_val = i2c.write(ADDR_LCD, &INIT_com[ii*2], 2);
        wait_ms(2);
    } //for
 
    while (1) {
        //液晶のクリア
        p_val = i2c.write(ADDR_LCD,INIT_cls,2);
        wait_ms(2);
        
        //温度の読み込み
        // Read temperature register
        i2c.read(ADDR, data_read,1,false);
 
        //温度の保存
        // Calculate temperature value in Celcius
        tempval =  data_read[0];
 
        //液晶に出力
        // Display result
        data_read[0] = '@';
        data_read[1] = (tempval/10)+'0';
        p_val = i2c.write(ADDR_LCD, data_read ,2);
        wait_ms(1);
        data_read[1] = (tempval%10)+'0';
        p_val = i2c.write(ADDR_LCD, data_read ,2);
        
        wait_ms(1000);
    }//while
 
}//main
 
