
#include "mbed.h"
#include "SSD1308.h"

//#include "font_8x8.h"
#include "font_16x24.h"


//i2c initialization
//I2C i2c(I2C_SDA, I2C_SCL); //767
//I2C i2c(PA_10, PA_9); //010


//void fff(char *str1)
//{
//    printf(str1);//debug
//}



/**
 *@brief Constructor
 *@param I2C *i2c reference to i2c
 *@param uint8_t deviceAddress slaveaddress
 */
//SSD1308::SSD1308(I2C *i2c, uint8_t deviceAddress) : _i2c(i2c) {
//SSD1308::SSD1308( uint8_t deviceAddress)  {
SSD1308::SSD1308( I2C_HandleTypeDef* hi2c , uint8_t deviceAddress )  {

  _hi2c = hi2c;
  
  _writeOpcode = deviceAddress & 0xFE; // low order bit = 0 for write
  _readOpcode  = deviceAddress | 0x01; // low order bit = 1 for read  
  
  initialize(); 
}//SSD1308

//イニシャライズ
void SSD1308::initialize()
{

    //fff("initialize\r\n");//debug

    setHorizontalAddressingMode(); //メモリーアクセスモード

    clearDisplay();

    //setInverted(false); //反転

    setDisplayOn();
    
    //fff("\r\n");
    
    //charge pump  add=>ca45040
    //i2c.write(SSD1308_SA0, "\200\215\200\024", 4); //0x80,0x8d,0x80,0x14
    HAL_I2C_Master_Transmit(   _hi2c        , _writeOpcode   , (uint8_t*)"\200\215\200\024", 4, 3000);
    //set access
    //setDisplayFlip(false, false);




//    uint8_t buf[16];
//
//
//            buf[0]=0;
//            buf[1]= 0x55;
//            
//            HAL_I2C_Master_Transmit(   _hi2c        ,  _writeOpcode  , buf, 2, 3000);          
//            wait_ms(600);
//
//            buf[0]=0;
//            buf[1]= 0xaa;
//
//
//            HAL_I2C_Master_Transmit(   _hi2c       ,  _writeOpcode  , buf, 2, 3000);           
//            wait_ms(600);





    
}//initialize

//クリアディスプレー
void SSD1308::clearDisplay()
{

    //fff("clearDisplay\r\n");//debug

    //setDisplayOff();
    setPageAddress(0, MAX_PAGE);  // all pages
    setColumnAddress(0, MAX_COL); // all columns

/*
    for (uint8_t page = 0; page < PAGES; page++) {
        for (uint8_t col = 0; col < COLUMNS; col++) {
            _sendData(0x00);
        }
    }
*/

    //128*64/8=1024
    uint8_t databytes[2] = {    DATA_MODE,    0x00 };
    for (int icount = 0; icount < 1024; icount++) {
        //_sendData(0x00);
        
        //i2c.write(_writeOpcode, databytes, 2);
        HAL_I2C_Master_Transmit(   _hi2c       ,  _writeOpcode  , databytes, 2, 3000);
    }

    //setDisplayOn();
}//clearDisplay

//ライトビットマップ
void SSD1308::writeBitmap(uint8_t* data,
                          uint8_t start_page, uint8_t end_page,
                          uint8_t start_col, uint8_t end_col)
{

    //fff("  writeBitmap\r\n");//debug

    int count = (end_page - start_page + 1) * (end_col - start_col + 1);

    //setDisplayOff();
    setPageAddress(start_page, end_page);  // set page window
    setColumnAddress(start_col, end_col);  // set column window



    uint8_t databytes[2] = {    DATA_MODE,    0 };
    for (int i=0; i<count; i++) {
        //_sendData(data[i]); // Write Data

        databytes[1] = data[i];
        //i2c.write(_writeOpcode, databytes, 2);
        HAL_I2C_Master_Transmit(   _hi2c       ,  _writeOpcode  , databytes , 2, 3000);
    }


    //setDisplayOn();
}//writeBitmap


//ライトビッグキャラ
void SSD1308::writeBigChar(uint8_t row, uint8_t col, char chr)
{

    //fff("writeBigChar\r\n");//debug


    writeBitmap((uint8_t*) font_16x24[int(chr) - FONT16x24_START],
                row, (row + FONT16x24_BYTES - 1),
                col, (col + FONT16x24_WIDTH - 1));
                

}//writeBigChar


/*
//センドコマンド コマンドx1
void SSD1308::_sendCommand(uint8_t command)
{
    char databytes[2] = {    COMMAND_MODE,    command             };
    i2c.write(_writeOpcode,databytes, 2); 
    //_i2c.write(_writeOpcode, databytes, 2);    // Write command
}//
*/



/*
//センドコマンド コマンドx1 パラメーターx1
void SSD1308::_sendCommand(uint8_t command, uint8_t param1)
{
    char databytes[4] = {    COMMAND_MODE,    command,    COMMAND_MODE,    param1              };
    
    i2c.write(_writeOpcode, databytes, 4);
    //_i2c.write(_writeOpcode, databytes, 4);    // Write command

}//
*/

/*
//センドコマンド コマンドx1 パラメーターx2
void SSD1308::_sendCommand(uint8_t command, uint8_t param1, uint8_t param2)
{
    char databytes[6] = {    COMMAND_MODE,    command,    COMMAND_MODE,    param1,    COMMAND_MODE,    param2              };
    i2c.write(_writeOpcode, databytes, 6);
    //_i2c.write(_writeOpcode, databytes, 6);    // Write command

}//
*/

/*
//センドコマンド コマンドx1 パラメーターx5
void SSD1308::_sendCommand(uint8_t command, uint8_t param1, uint8_t param2,
                           uint8_t param3, uint8_t param4,
                           uint8_t param5)
{
    char databytes[12] = {    COMMAND_MODE,    command,    COMMAND_MODE,    param1,    COMMAND_MODE,    param2,
    COMMAND_MODE,    param3,    COMMAND_MODE,    param4,    COMMAND_MODE,    param5               };
    i2c.write(_writeOpcode, databytes, 12);
    //_i2c.write(_writeOpcode, databytes, 12);    // Write command
}//
*/

/*
//センドコマンド コマンドx1 パラメーターx6
void SSD1308::_sendCommand(uint8_t command, uint8_t param1, uint8_t param2,
                           uint8_t param3, uint8_t param4,
                           uint8_t param5, uint8_t param6)
{
    char databytes[14] = {    COMMAND_MODE,    command,    COMMAND_MODE,    param1,    COMMAND_MODE,    param2,
    COMMAND_MODE,    param3,    COMMAND_MODE,    param4,    COMMAND_MODE,    param5,    COMMAND_MODE,    param6              };
    i2c.write(_writeOpcode, databytes, 14);
    //_i2c.write(_writeOpcode, databytes, 14);    // Write command

}//
*/

/*
//センドデータ コマンドx1
void SSD1308::_sendData(uint8_t data)
{
    char databytes[2] = {    DATA_MODE,    data };
    i2c.write(_writeOpcode, databytes, 2);
    //_i2c.write(_writeOpcode, databytes, 2);    // Write Data
}//
*/

/*
//センドデータ コマンドx1 データ
void SSD1308::_sendData(uint8_t len, uint8_t* data)
{
    for (int i=0; i<len ; i++) {
        _sendData(data[i]);  // Write Data
    }
}//_sendData
*/

//セット
void SSD1308::setHorizontalAddressingMode()
{

    //fff("setHorizontalAddressingMode\r\n");//debug

    setMemoryAddressingMode(HORIZONTAL_ADDRESSING_MODE);
}//setHorizontalAddressingMode

//セットメモリーアドレシングモード
void SSD1308::setMemoryAddressingMode(uint8_t mode)
{
    
    //fff("setMemoryAddressingMode\r\n");
    
    //_sendCommand(SET_MEMORY_ADDRESSING_MODE, mode);
 
 
    uint8_t databytes[4] = {    COMMAND_MODE,    SET_MEMORY_ADDRESSING_MODE,    COMMAND_MODE,    mode              };
    
    //i2c.write(_writeOpcode, databytes, 4);
    HAL_I2C_Master_Transmit(   _hi2c       ,  _writeOpcode  , databytes, 4, 3000);
 
 
}//setMemoryAddressingMode

//セットページアドレス
void SSD1308::setPageAddress(uint8_t start, uint8_t end)
{
    
    //fff("setPageAddress\r\n");
    
    //_sendCommand(SET_PAGE_ADDRESS, start, end);
    
    uint8_t databytes[6] = {    COMMAND_MODE,    SET_PAGE_ADDRESS,    COMMAND_MODE,    start,    COMMAND_MODE,    end              };
    //i2c.write(_writeOpcode, databytes, 6);
    HAL_I2C_Master_Transmit(   _hi2c       ,  _writeOpcode  , databytes, 6, 3000);
    
    
}//setPageAddress

//セットカラムアクセス
void SSD1308::setColumnAddress(uint8_t start, uint8_t end)
{
    
    //fff("setColumnAddress");
    
    //_sendCommand(SET_COLUMN_ADDRESS, start, end);
    
    uint8_t databytes[6] = {    COMMAND_MODE,    SET_COLUMN_ADDRESS,    COMMAND_MODE,    start,    COMMAND_MODE,    end              };
    //i2c.write(_writeOpcode, databytes, 6);
    HAL_I2C_Master_Transmit(   _hi2c       ,  _writeOpcode  , databytes, 6, 3000);
    
}//setColumnAddress

//セットディスプレーオン
void SSD1308::setDisplayOn()
{

    //fff("setDisplayOn\r\n");//debug

    //_sendCommand(SET_DISPLAY_POWER_ON);
    
    
    uint8_t databytes[2] = {    COMMAND_MODE,    SET_DISPLAY_POWER_ON             };
    //i2c.write(_writeOpcode,databytes, 2); 
    HAL_I2C_Master_Transmit(   _hi2c       ,  _writeOpcode  , databytes, 2, 3000);
    
}//setDisplayOn


/*
//セットディスプレーオフ
void SSD1308::setDisplayOff()
{
    _sendCommand(SET_DISPLAY_POWER_OFF);
}//setDisplayOff
*/

/*
//セットディスプレー Flip
void SSD1308::setDisplayFlip(bool left, bool down)
{
    if (left) {
        // column address   0 is mapped to SEG0 (Reset)
        _sendCommand(SET_SEGMENT_REMAP_0);
    } else {
        // column address 127 is mapped to SEG0
        _sendCommand(SET_SEGMENT_REMAP_127);
    }

    if (down) {
        // Reset mode
        _sendCommand(SET_COMMON_REMAP_0);
    } else {
        // Flip Up/Down (Need to rewrite display before H effect shows)
        _sendCommand(SET_COMMON_REMAP_63);
    }

}//setDisplayFlip
*/