
#include "mbed.h"
#include "SSD1308.h"

//#include "font_8x8.h"
#include "font_16x24.h"

//最初に呼び出される
SSD1308::SSD1308( I2C *i2c,uint8_t deviceAddress)
{
    _i2c = i2c;

    _writeOpcode = deviceAddress & 0xFE; // low order bit = 0 for write
    _readOpcode  = deviceAddress | 0x01; // low order bit = 1 for read

    initialize();
}//SSD1308

//イニシャライズ
void SSD1308::initialize()
{
    //リセット対策
    wait_ms(100);
    _i2c->write(_writeOpcode, "\200\215\200\024\200\257", 6);
    wait_ms(100);
    _i2c->write(_writeOpcode, "\200\215\200\024\200\257", 6);
    wait_ms(100);
    _i2c->write(_writeOpcode, "\200\215\200\024\200\257", 6);
    wait_ms(100);

    setHorizontalAddressingMode(); //メモリーアクセスモード

    clearDisplay();

    setDisplayOn();

    //charge pump  add=>ca45040
    _i2c->write(_writeOpcode, "\200\215\200\024", 4); //0x80,0x8d,0x80,0x14
    //set access
    //setDisplayFlip(false, false);

}//initialize

//クリアディスプレー
void SSD1308::clearDisplay()
{
    setPageAddress(0, MAX_PAGE);  // all pages
    setColumnAddress(0, MAX_COL); // all columns

    //128*64/8=1024
    char databytes[2] = {DATA_MODE,0x00};
    for (int icount = 0; icount < 1024; icount++) {
        _i2c->write(_writeOpcode, databytes, 2);
    }//for
}//clearDisplay

//ライトビットマップ
void SSD1308::writeBitmap(uint8_t* data,
                          uint8_t start_page, uint8_t end_page,
                          uint8_t start_col, uint8_t end_col)
{
    int count = (end_page - start_page + 1) * (end_col - start_col + 1);

    setPageAddress(start_page, end_page);  // set page window
    setColumnAddress(start_col, end_col);  // set column window

    char databytes[2] = {DATA_MODE,0x00};
    for (int i=0; i<count; i++) {
        databytes[1] = data[i];
        _i2c->write(_writeOpcode, databytes, 2);
    }//for
}//writeBitmap

//ライトビッグキャラ
void SSD1308::writeBigChar(uint8_t row, uint8_t col, char chr)
{
    writeBitmap((uint8_t*) font_16x24[int(chr) - FONT16x24_START],
                row, (row + FONT16x24_BYTES - 1),
                col, (col + FONT16x24_WIDTH - 1));
}//writeBigChar

//セットホリゾンタルアドレシングモード(水平)
void SSD1308::setHorizontalAddressingMode()
{
    setMemoryAddressingMode(HORIZONTAL_ADDRESSING_MODE);
}//setHorizontalAddressingMode

//セットメモリーアドレシングモード
void SSD1308::setMemoryAddressingMode(uint8_t mode)
{
    char databytes[4] = {COMMAND_MODE,SET_MEMORY_ADDRESSING_MODE,COMMAND_MODE,mode};
    _i2c->write(_writeOpcode, databytes, 4);
}//setMemoryAddressingMode

//セットページアドレス
void SSD1308::setPageAddress(uint8_t start, uint8_t end)
{
    char databytes[6] = {COMMAND_MODE,SET_PAGE_ADDRESS,COMMAND_MODE,start,COMMAND_MODE,end};
    _i2c->write(_writeOpcode, databytes, 6);
}//setPageAddress

//セットカラムアクセス
void SSD1308::setColumnAddress(uint8_t start, uint8_t end)
{
    char databytes[6] = {COMMAND_MODE,SET_COLUMN_ADDRESS,COMMAND_MODE,start,COMMAND_MODE,end};
    _i2c->write(_writeOpcode, databytes, 6);
}//setColumnAddress

//セットディスプレーオン
void SSD1308::setDisplayOn()
{
    char databytes[2] = {COMMAND_MODE,SET_DISPLAY_POWER_ON};
    _i2c->write(_writeOpcode,databytes, 2);
}//setDisplayOn

/*
//セットディスプレーオフ
void SSD1308::setDisplayOff()
{
    _sendCommand(SET_DISPLAY_POWER_OFF);
}//setDisplayOff
*/

/*
//セットディスプレー Flip
void SSD1308::setDisplayFlip(bool left, bool down)
{
    if (left) {
        // column address   0 is mapped to SEG0 (Reset)
        _sendCommand(SET_SEGMENT_REMAP_0);
    } else {
        // column address 127 is mapped to SEG0
        _sendCommand(SET_SEGMENT_REMAP_127);
    }

    if (down) {
        // Reset mode
        _sendCommand(SET_COMMON_REMAP_0);
    } else {
        // Flip Up/Down (Need to rewrite display before H effect shows)
        _sendCommand(SET_COMMON_REMAP_63);
    }

}//setDisplayFlip
*/
