
#include "mbed.h"
#include "SSD1308.h"

//#include "font_8x8.h"
#include "font_16x24.h"

//最初に呼ばれるプログラム
SSD1308::SSD1308(I2C_HandleTypeDef* hi2c, uint8_t deviceAddress )
{
    _hi2c = hi2c;

    _writeOpcode = deviceAddress & 0xFE; // low order bit = 0 for write
    _readOpcode  = deviceAddress | 0x01; // low order bit = 1 for read

    initialize();
}//SSD1308

int ran1;
#define WAIT2()   for(int ii=0;ii<1000;ii++){ran1=ran1+(int)(rand()*10);}


//イニシャライズ
void SSD1308::initialize()
{
    //リセット対策
    //wait_ms(100);
    WAIT2();
    HAL_I2C_Master_Transmit(_hi2c,_writeOpcode,(uint8_t*)"\200\215\200\024\200\257", 6, 3000);
    //wait_ms(100);
    WAIT2();
    HAL_I2C_Master_Transmit(_hi2c,_writeOpcode,(uint8_t*)"\200\215\200\024\200\257", 6, 3000);
    //wait_ms(100);
    WAIT2();
    HAL_I2C_Master_Transmit(_hi2c,_writeOpcode,(uint8_t*)"\200\215\200\024\200\257", 6, 3000);
    //wait_ms(100);
    WAIT2();

    setHorizontalAddressingMode(); //メモリーアクセスモード

    clearDisplay();

    setDisplayOn();

    //charge pump  add=>ca45040
    //0x80,0x8d,0x80,0x14
    HAL_I2C_Master_Transmit(_hi2c,_writeOpcode,(uint8_t*)"\200\215\200\024", 4, 3000);
    //set access
    //setDisplayFlip(false, false);
}//initialize

//クリアディスプレー
void SSD1308::clearDisplay()
{
    setPageAddress(0, MAX_PAGE);  // all pages
    setColumnAddress(0, MAX_COL); // all columns

    //128*64/8=1024
    uint8_t databytes[2] = {DATA_MODE,0x00};
    for (int icount = 0; icount < 1024; icount++) {
        HAL_I2C_Master_Transmit(_hi2c, _writeOpcode, databytes, 2, 3000);
    }
}//clearDisplay

//ライトビットマップ
void SSD1308::writeBitmap(uint8_t* data,
                          uint8_t start_page, uint8_t end_page,
                          uint8_t start_col, uint8_t end_col)
{
    int count = (end_page - start_page + 1) * (end_col - start_col + 1);

    setPageAddress(start_page, end_page);  // set page window
    setColumnAddress(start_col, end_col);  // set column window

    uint8_t databytes[2] = {DATA_MODE,0x00};
    for (int i=0; i<count; i++) {
        databytes[1] = data[i];
        HAL_I2C_Master_Transmit(_hi2c,_writeOpcode, databytes, 2, 3000);
    }
}//writeBitmap

//ライトビッグキャラ
void SSD1308::writeBigChar(uint8_t row, uint8_t col, char chr)
{
    writeBitmap((uint8_t*) font_16x24[int(chr) - FONT16x24_START],
                row, (row + FONT16x24_BYTES - 1),
                col, (col + FONT16x24_WIDTH - 1));
}//writeBigChar

//セットホリゾンタルアドレシングモード(水平)
void SSD1308::setHorizontalAddressingMode()
{
    setMemoryAddressingMode(HORIZONTAL_ADDRESSING_MODE);
}//setHorizontalAddressingMode

//セットメモリーアドレシングモード
void SSD1308::setMemoryAddressingMode(uint8_t mode)
{
    uint8_t databytes[4] = {COMMAND_MODE,SET_MEMORY_ADDRESSING_MODE,COMMAND_MODE,mode};
    HAL_I2C_Master_Transmit(_hi2c,_writeOpcode,databytes, 4, 3000);
}//setMemoryAddressingMode

//セットページアドレス
void SSD1308::setPageAddress(uint8_t start, uint8_t end)
{
    uint8_t databytes[6] = {COMMAND_MODE,SET_PAGE_ADDRESS,COMMAND_MODE,start,COMMAND_MODE,end};
    HAL_I2C_Master_Transmit(_hi2c,_writeOpcode, databytes, 6, 3000);
}//setPageAddress

//セットカラムアドレス
void SSD1308::setColumnAddress(uint8_t start, uint8_t end)
{
    uint8_t databytes[6] = {COMMAND_MODE,SET_COLUMN_ADDRESS,COMMAND_MODE,start,COMMAND_MODE,end};
    HAL_I2C_Master_Transmit(_hi2c,_writeOpcode, databytes, 6, 3000);
}//setColumnAddress

//セットディスプレーオン
void SSD1308::setDisplayOn()
{
    uint8_t databytes[2] = {COMMAND_MODE,SET_DISPLAY_POWER_ON};
    HAL_I2C_Master_Transmit(_hi2c,_writeOpcode, databytes, 2, 3000);
}//setDisplayOn

/*
//セットディスプレーオフ
void SSD1308::setDisplayOff()
{
    _sendCommand(SET_DISPLAY_POWER_OFF);
}//setDisplayOff
*/

/*
//セットディスプレー Flip
void SSD1308::setDisplayFlip(bool left, bool down)
{
    if (left) {
        // column address   0 is mapped to SEG0 (Reset)
        _sendCommand(SET_SEGMENT_REMAP_0);
    } else {
        // column address 127 is mapped to SEG0
        _sendCommand(SET_SEGMENT_REMAP_127);
    }

    if (down) {
        // Reset mode
        _sendCommand(SET_COMMON_REMAP_0);
    } else {
        // Flip Up/Down (Need to rewrite display before H effect shows)
        _sendCommand(SET_COMMON_REMAP_63);
    }

}//setDisplayFlip
*/
