#include "mbed.h"
#include "rtos.h"

Serial pc(USBTX, USBRX);
Timer t;
Mutex m;
Semaphore sem_event(0);
Semaphore sem_event_done(0);
bool lock = false;

void thread_main(void const *argument)
{
    while (true) {
        sem_event.wait();
        if (lock) {
            m.lock();
        } else {
            m.unlock();
        }
        sem_event_done.release();
    }
}


int main(void)
{
    pc.baud(115200);
    t.start();
    Thread thread(thread_main, NULL, osPriorityLow);

    // Test timer with Thread::wait(1000);
    uint32_t start = t.read_us();
    Thread::wait(1000);
    uint32_t stop = t.read_us();
    pc.printf("Test delay of 1s: %luus\r\n", stop - start);
    
    
    // Test consecutive call to timer
    uint32_t max_us = 0;
    uint32_t min_us = 0xffffffff;
    for (int i = 0; i < 1000; i++) {
        start = t.read_us();
        stop = t.read_us();
        uint32_t diff = stop - start;
        if (diff > max_us) {
            max_us = diff;
        }
        if (diff < min_us) {
            min_us = diff;
        }
    }
    printf("Timer min, max: %luus, %luus\r\n", min_us, max_us);
    
    // Test repeated mutex acquire and release
    max_us = 0;
    min_us = 0xffffffff;
    for (int i = 0; i < 1000; i++) {
        start = t.read_us();
        m.lock();
        stop = t.read_us();
        m.unlock();
        uint32_t diff = stop - start;
        if (diff > max_us) {
            max_us = diff;
        }
        if (diff < min_us) {
            min_us = diff;
        }
    }
    printf("lock min, max: %luus, %luus\r\n", min_us, max_us);
    
    // Test repeated mutex acquire and release
    max_us = 0;
    min_us = 0xffffffff;
    for (int i = 0; i < 1000; i++) {
        m.lock();
        start = t.read_us();
        m.unlock();
        stop = t.read_us();
        uint32_t diff = stop - start;
        if (diff > max_us) {
            max_us = diff;
        }
        if (diff < min_us) {
            min_us = diff;
        }
    }
    printf("unlock min, max: %luus, %luus\r\n", min_us, max_us);
    
    // Test repeated use of locked mutex
    max_us = 0;
    min_us = 0xffffffff;
    for (int i = 0; i < 1000; i++) {

        // Make another thread lock the mutex
        lock = true;
        sem_event.release();
        sem_event_done.wait();

        // Make the other thead unlock the mutex
        // Note - this thread is lower priority so it will not
        // start unlocking until main is suspended
        lock = false;
        sem_event.release();
        // Try and acquire the mutex
        start = t.read_us();
        m.lock();
        stop = t.read_us();
        m.unlock();
        // Decrement event done count
        sem_event_done.wait();

        uint32_t diff = stop - start;
        if (diff > max_us) {
            max_us = diff;
        }
        if (diff < min_us) {
            min_us = diff;
        }
    }
    printf("Lock already locked mutex min, max: %luus, %luus\r\n", min_us, max_us);

    while (true) {
        Thread::wait(1000);
    }
}
