#include "mbed.h"
// For debugging only
extern "C" {
#include "fsl_rtc.h"
}

DigitalOut led1(LED1);

int main() {
    led1 = 1;

    // For debugging only
    CLOCK_EnableClock(kCLOCK_Rtc0);
    printf("Enabled interrupts: 0x%x\r\n", RTC->IER);
    printf("Pending interrupts: 0x%x\r\n", RTC->SR & 0x7);

    set_time(0xFFFFFFFE);

    while (true) {
        led1 = !led1;
        wait(1.0);
    }
}

