#include "mbed.h"
// For debugging only
extern "C" {
#include "fsl_rtc.h"
}

DigitalOut led1(LED1);

void cb_done()
{
    // Dummy callback
}

int main() {
    led1 = 1;

    // For debugging only
    CLOCK_EnableClock(kCLOCK_Rtc0);
    printf("TSR: %i\r\n", RTC->TSR);
    printf("TAR: %i\r\n", RTC->TAR);
    printf("Enabled interrupts: 0x%x\r\n", RTC->IER);
    printf("Pending interrupts: 0x%x\r\n", RTC->SR & 0x7);

    LowPowerTimeout lpt;
    set_time(1000);
    lpt.attach(&cb_done, 3);

    core_util_critical_section_enter();
    for (int i = 0; i < 3; i++) {
        led1 = !led1;
        wait(1.0);
    }
    while (true) {
        led1 = !led1;
        wait(0.2);
    }
}
