// ----------------------------------------------------------------------------
// Copyright 2019 ARM Ltd.
//
// SPDX-License-Identifier: Apache-2.0
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ----------------------------------------------------------------------------

#include "mbed.h"
#include "GroveGPS.h"

GroveGPS gps(A3, A2);

void read_gps() {
    char latBuffer[16], lonBuffer[16];
    gps.getLatitude(latBuffer);
    gps.getLongitude(lonBuffer);

    // Utilize latitude and longitude values here
    printf("\r\nLatitude: %s\r\nLongitude: %s\r\n", latBuffer, lonBuffer);
}

int main() {
    EventQueue queue;
    queue.call_every(1000, read_gps);
    queue.dispatch();
}
