

#include "EncoderCounter.h"

#include "FastIO.h"


      FastOut<PA_0> HCTL_PIN_XY;
      FastOut<PA_1> HCTL_PIN_OE; // Active LOW
      FastOut<PA_4> HCTL_PIN_EN1;
      FastOut<PB_3> HCTL_PIN_EN2;
      FastOut<PC_10> HCTL_PIN_SEL1;
      FastOut<PC_11> HCTL_PIN_SEL2;
      FastOut<PB_6> HCTL_PIN_RSTX; // Active LOW
      FastOut<PB_7> HCTL_PIN_RSTY; // Active LOW
      
  
      FastIn<PC_0> bus0;
      FastIn<PC_1> bus1;    
      FastIn<PC_2> bus2;
      FastIn<PC_3> bus3; 
      FastIn<PC_4> bus4;
      FastIn<PC_5> bus5; 
      FastIn<PC_6> bus6;
      FastIn<PC_7> bus7;       
      //PortIn HCTL_DataBus(PortC, 0x00FF);
      


ENCODER::ENCODER(unsigned char countMode)

{


   switchCountMode( countMode );


 
   XAxisReset();
   YAxisReset();
   
   HCTL_PIN_RSTX = 1;  // Active LOW
   HCTL_PIN_RSTY = 1;  // Active LOW   
   HCTL_PIN_OE = 1;
   wait_ms(1);
   

}

   
    
// Communicates with a HCTL-2032 IC to get reset the X encoder count
// see Avago/Agilent/HP HCTL-2032 PDF for details
void ENCODER::XAxisReset()
{
   HCTL_PIN_RSTX = 0;
   wait_ms(0);
   HCTL_PIN_RSTX = 1;
   wait_ms(1);
}

void ENCODER::YAxisReset()
{
   HCTL_PIN_RSTX = 0;
   wait_ms(0);
   HCTL_PIN_RSTX = 1;
   wait_ms(1);
}

// Communicates with a HCTL-2032 IC to get the X Axis encoder count via an 8bit parallel bus
// see Avago/Agilent/HP HCTL-2032 Datasheet PDF for details
 int ENCODER::XAxisGetCount( )
{

   HCTL_PIN_XY = 0;  //0
   HCTL_PIN_OE = 0;
   wait_ms(5);
   

   //read MSB
   HCTL_PIN_SEL1 = 0;  //0
   HCTL_PIN_SEL2 = 1;  //1
   wait_ms(5);
   busByteMSB = (bus0 | (bus1 << 1) | (bus2 << 2) | (bus3 << 3) | (bus4 << 4) | (bus5 << 5) | (bus6 << 6) | (bus7 << 7) );
   countEnc = busByteMSB;
   countEnc <<= 8 ;

 
  
   //read 2nd byte
   HCTL_PIN_SEL1 = 1;
   HCTL_PIN_SEL2 = 1;    
   wait_ms(5);
   busByte = (bus0 | (bus1 << 1) | (bus2 << 2) | (bus3 << 3) | (bus4 << 4) | (bus5 << 5) | (bus6 << 6) | (bus7 << 7) );
   countEnc = busByte + countEnc;
   countEnc <<= 8 ;


      
   //read 3rd byte
   HCTL_PIN_SEL1 = 0;
   HCTL_PIN_SEL2 = 0;
   HCTL_PIN_OE = 0;
   wait_ms(5);
   busByte = (bus0 | (bus1 << 1) | (bus2 << 2) | (bus3 << 3) | (bus4 << 4) | (bus5 << 5) | (bus6 << 6) | (bus7 << 7) );
   countEnc = busByte + countEnc;
   countEnc <<= 8;

      
   //read LSB
   HCTL_PIN_SEL1 = 1;
   HCTL_PIN_SEL2 = 0;
   wait_ms(5);
   busByte = (bus0 | (bus1 << 1) | (bus2 << 2) | (bus3 << 3) | (bus4 << 4) | (bus5 << 5) | (bus6 << 6) | (bus7 << 7) );
   countEnc = busByte + countEnc;
 
   
   HCTL_PIN_OE = 1; //1


   return countEnc;
}

int ENCODER::YAxisGetCount( )
{

   HCTL_PIN_XY = 0;  //0
   HCTL_PIN_OE = 0;
   wait_ms(5);
   

   //read MSB
   HCTL_PIN_SEL1 = 0;  //0
   HCTL_PIN_SEL2 = 1;  //1
   wait_ms(5);
   busByteMSB = (bus0 | (bus1 << 1) | (bus2 << 2) | (bus3 << 3) | (bus4 << 4) | (bus5 << 5) | (bus6 << 6) | (bus7 << 7) );
   countEnc = busByteMSB;
   countEnc <<= 8 ;

 
  
   //read 2nd byte
   HCTL_PIN_SEL1 = 1;
   HCTL_PIN_SEL2 = 1;    
   wait_ms(5);
   busByte = (bus0 | (bus1 << 1) | (bus2 << 2) | (bus3 << 3) | (bus4 << 4) | (bus5 << 5) | (bus6 << 6) | (bus7 << 7) );
   countEnc = busByte + countEnc;
   countEnc <<= 8 ;


      
   //read 3rd byte
   HCTL_PIN_SEL1 = 0;
   HCTL_PIN_SEL2 = 0;
   HCTL_PIN_OE = 0;
   wait_ms(5);
   busByte = (bus0 | (bus1 << 1) | (bus2 << 2) | (bus3 << 3) | (bus4 << 4) | (bus5 << 5) | (bus6 << 6) | (bus7 << 7) );
   countEnc = busByte + countEnc;
   countEnc <<= 8;

      
   //read LSB
   HCTL_PIN_SEL1 = 1;
   HCTL_PIN_SEL2 = 0;
   wait_ms(5);
   busByte = (bus0 | (bus1 << 1) | (bus2 << 2) | (bus3 << 3) | (bus4 << 4) | (bus5 << 5) | (bus6 << 6) | (bus7 << 7) );
   countEnc = busByte + countEnc;
 
   
   HCTL_PIN_OE = 1; //1


   return countEnc;
}

void ENCODER::switchCountMode( unsigned char countMode )
{
   // Count Mode Illegal Mode EN1 LOW  EN2 LOW
   // Count Mode   4X         EN1 HIGH EN2 LOW
   // Count Mode   2X         EN1 LOW  EN2 HIGH
   // Count Mode   1X         EN1 HIGH EN2 HIGH
   switch(countMode)
   {
      case 1: // 1X Count Mode
         HCTL_PIN_EN1 = 1;
         HCTL_PIN_EN2 = 1;
         break;
      case 2: // 2X Count Mode
         HCTL_PIN_EN1 = 0;
         HCTL_PIN_EN2 = 1;
         break;
      case 4: // 4X Count Mode is the default
         HCTL_PIN_EN1 = 1;
         HCTL_PIN_EN2 = 0;
         break;
      default:
         HCTL_PIN_EN1 = 1;
         HCTL_PIN_EN2 = 0;
         break;

                 
   }
   wait_ms(1);
}


