/*
 * Using STM32's counter peripherals to interface rotary encoders.
 * Encoders are supported on F4xx's TIM1,2,3,4,5. TIM2 & TIM5 have 32bit count, others 16bit.
 * Beware mbed uses TIM5 for system timer, others for PWM.
 * Check your platform's PeripheralPins.c & PeripheralNames.h if you need both PWM & encoders.
 *
 * Edit HAL_TIM_Encoder_MspInitFx.cpp to suit your mcu & board's available pinouts & pullups/downs.
 *
 * Thanks to:
 * http://petoknm.wordpress.com/2015/01/05/rotary-encoder-and-stm32/
 *
 * References:
 * http://www.st.com/st-web-ui/static/active/en/resource/technical/document/user_manual/DM00122015.pdf
 * http://www.st.com/st-web-ui/static/active/en/resource/technical/document/reference_manual/DM00096844.pdf
 * http://www.st.com/web/en/resource/technical/document/application_note/DM00042534.pdf
 * http://www.st.com/web/en/resource/technical/document/datasheet/DM00102166.pdf
 * 
 * David Lowe Jan 2015
 */

#include "mbed.h"
#include "Encoder.h"

TIM_Encoder_InitTypeDef encoder2;
TIM_HandleTypeDef timer2;
TIM_IC_InitTypeDef counterSet2;

int main()
{
    //examples
    
    //counting on A-input only, 2 ticks per cycle, rolls over at 100
    //EncoderInit(encoder1, timer1, TIM1, 0xffff, TIM_ENCODERMODE_TI1);
    
    //counting on both A&B inputs, 4 ticks per cycle, full 32-bit count
    EncoderInit(encoder2, timer2, counterSet2, TIM2, 0xffff, 0);
    TIM2->SMCR |= 0x0007; // Ext. clk mode 1
    TIM2->SMCR |= 0x0060; // TI2FP2 as ext. clock
    TIM2->CR1 |= 0x0001; // enable counting
    TIM2->CNT = 0; // reset counter

 while (1) {
        int16_t count1;
        count1=TIM2->CNT; 

        printf("%d\r\n", count1);
        wait(1.0);
   if (GPIOE->IDR & 0x01) TIM2->CNT = 0; // reset counter
   if (1 * TIM_CR1_DIR) TIM2->CR1 |= 0;  // 0 - count up; 1 - count down

 //if (GPIOE->IDR & 0x02) TIM2->CR1 |= 0x01; // enable counter
 //if (GPIOE->IDR & 0x04) TIM2->CR1 &= ~0x01; // disable counter
 }
}
