#ifdef TARGET_NUCLEO_F401RE

#include "mbed.h"
#include "pinmap.h"

typedef struct {
    uint32_t mask;
} fastio_vars;

#define PINMASK             (1 << STM_PIN(pin))
#define PORT                ((GPIO_TypeDef *)(GPIOA_BASE + 0x0400 * STM_PORT(pin)))

#define INIT_PIN            RCC->AHB1ENR |= (1 << STM_PORT(pin)); (PORT->MODER &= ~(GPIO_MODER_MODER0_1 << (STM_PIN(pin) * 2))); container.mask = PINMASK
#define DESTROY_PIN     

#define SET_DIR_INPUT       (PORT->MODER &= ~(GPIO_MODER_MODER0_0 << (STM_PIN(pin) * 2)))
#define SET_DIR_OUTPUT      (PORT->MODER |= (GPIO_MODER_MODER0_0 << (STM_PIN(pin) * 2)))
#define SET_MODE(pull)      pin_mode(pin, pull);
#define SET_FUNCTION        pin_function(pin, STM_PIN_DATA(2, GPIO_NOPULL, GPIO_AF10_OTG_FS));

//pin_function(PA_10, STM_PIN_DATA(STM_MODE_AF_OD, GPIO_PULLUP));
//void pin_function(PinName pin, int data) {
//    MBED_ASSERT(pin != (PinName)NC);
//    // Get the pin informations
//    uint32_t mode  = STM_PIN_MODE(data);
//    uint32_t pupd  = STM_PIN_PUPD(data);
//    uint32_t afnum = STM_PIN_AFNUM(data);

//    uint32_t port_index = STM_PORT(pin);
//    uint32_t pin_index  = STM_PIN(pin);

    // Enable GPIO clock
//    uint32_t gpio_add = Set_GPIO_Clock(port_index);
//    GPIO_TypeDef *gpio = (GPIO_TypeDef *)gpio_add;

    // Configure GPIO
//    GPIO_InitTypeDef GPIO_InitStructure;
//   GPIO_InitStructure.Pin       = (uint32_t)(1 << pin_index);
//    GPIO_InitStructure.Mode      = gpio_mode[mode];
//    GPIO_InitStructure.Pull      = pupd;
//    GPIO_InitStructure.Speed     = GPIO_SPEED_HIGH;
//    GPIO_InitStructure.Alternate = afnum;
//    HAL_GPIO_Init(gpio, &GPIO_InitStructure);


#define WRITE_PIN_SET       (PORT->BSRRL = PINMASK)
#define WRITE_PIN_CLR       (PORT->BSRRH = PINMASK)

#define READ_PIN            ((PORT->IDR & container.mask) ? 1 : 0)

#endif

