#include "mbed.h"
#include "Date.h"

uint8_t Date::bcdToUint(uint8_t const nybbles)
{
    uint8_t result;
    result = (nybbles>>4)*10 + (nybbles & 0x0F);
    return result;
}

string Date::toString(uint8_t value)
{
    char buffer[2];
    sprintf (buffer, "%d", value);
    return buffer;
}    

uint8_t Date::GetDay()
{
    uint8_t day = rtc_read(DAYS);
    return bcdToUint(day & 0x3F);
}
uint8_t Date::GetDay(int value)   
{
    return value;
}
string Date::GetDay(string str)
{
    string day = str + " In Date Day: " + toString(GetDay());
    return day;
}