#include "mbed.h"
#include "pt.h"
#define numsamples 1
AnalogIn input(p20);
DigitalIn charger(p19);
DigitalOut ground(p18);
AnalogIn input1(p15);
DigitalIn charger1(p16);
DigitalOut ground1(p17);
DigitalOut myled0(LED1);
DigitalOut myled1(LED2);
DigitalOut myled2(LED3);
DigitalOut myled3(LED4);
Serial pc(USBTX, USBRX); // tx, rx
static int protothreadTS0(struct pt *pt);
static int protothreadTS1(struct pt *pt);
static int protothreadSense(struct pt *pt);
static int protothreadMatch(struct pt *pt);
static int protothreadReport(struct pt *pt);
int TS[2];
int match;
int Tsense;
struct pt ptTS1;
struct pt ptTS0;
struct pt ptSense;
struct pt ptMatch;
struct pt ptReport;
int main() {
    while (1) {
        protothreadMatch(&ptMatch);
        protothreadReport(&ptReport);
    }
}
static int protothreadMatch(struct pt *pt) {
    PT_BEGIN(pt);
    while (1) {
        char r;
        int sp;
        match=1;
        r=pc.getc();
        while (r!='S') {
            r=pc.getc();
        }
        while ((r!='E')&(match==1)) {
            do {
                r=pc.getc();
            } while   ((r!='E')&(r!='0')&(r!='1'));
            if (r=='E') {
                PT_EXIT(pt);
            }
            protothreadSense(&ptSense);
            sp=Tsense;
            if (sp==2) {
                match=2;
                PT_EXIT(pt);
            } else {
                if (((sp==1)&(r=='1'))^((sp==0)&(r=='0'))) {
                    match=1;
                } else {
                    match=0;
                    PT_EXIT(pt);
                }
            }
        }

    }
    PT_END(pt);
}
static int protothreadReport(struct pt *pt) {
    PT_BEGIN(pt);
    switch (match) {
        case 0:
            pc.printf("HOST ERROR \n\r");
            PT_EXIT(pt);
        case 1:
            pc.printf("MATCH \n\r");
            PT_EXIT(pt);
        case 2:
            pc.printf("Touch Error \n\r");
            PT_EXIT(pt);
    }
    PT_END(pt);
}

static int protothreadSense(struct pt *pt) {
    PT_BEGIN(pt);
    while (1) {
        protothreadTS0(&ptTS0);
        protothreadTS1(&ptTS1);
        if (TS[0]*TS[1]==1) {
            Tsense= 2;
            PT_EXIT(pt);
        } else {
            if (TS[0]==1) {
                while (TS[0]==1) {
                    wait (0.5);
                    protothreadTS0(&ptTS0);
                    protothreadTS1(&ptTS1);
                    if (TS[0]*TS[1]==1) {
                        Tsense= 2;
                        PT_EXIT(pt);
                    }
                }
                myled0=!myled0;
                Tsense= 0;
                PT_EXIT(pt);
            } else {
                if (TS[1]==1) {
                    while (TS[1]==1) {
                        wait (0.5);
                        protothreadTS0(&ptTS0);
                        protothreadTS1(&ptTS1);
                        if (TS[0]*TS[1]==1) {
                            Tsense= 2;
                            PT_EXIT(pt);
                        }
                    }
                    myled1=!myled1;
                    Tsense= 1;
                    PT_EXIT(pt);
                }
            }
        }
        wait(0.005);
    }
    PT_END(pt);
}


static int protothreadTS0(struct pt *pt) {
    PT_BEGIN(pt);
    float sample;
    ground = 0;
    charger.mode(PullUp);
    charger.mode(PullNone);
    sample=input.read();
    if (sample < 0.3) {
        TS[0]= 1;
    } else {
        TS[0]= 0;
    }
    PT_END(pt);
}
static int protothreadTS1(struct pt *pt) {
    PT_BEGIN(pt);
    float sample;
    ground1 = 0;
    charger1.mode(PullUp);
    charger1.mode(PullNone);
    sample=input1.read();
    if (sample < 0.3) {
        TS[1]= 1;
    } else {
        TS[1]= 0;
    }
    PT_END(pt);
}
