#include "mbed.h"
#include "main_init.h"
#include "i2c_mbed_fpga.h"
#include "uart_mbed.h"

#define RAM_END_ADDR 0x4B

#define CLIM_LEVEL 0xFF
// I_LIM (A) = 4A * CLIM_LEVEL/127

/* Main function */
int main() {
    char i2cBuffer[3];
    char i2cTestPassFlag = 0;
    char i2cRamDumpFlag = 0;
    
    /*init funcitons*/
    i2c_mbed_fpga i2c;
    main_init();  /*reset the FPGA!*/ 
    
    /*control codes*/
      wait_ms(2000);   /* keep FPGA in reset for 5s, to let motor stop*/
      enbale_fpga();   /* enable FPGA */ 
      wait_ms(40);      
      i2c.i2c_config_mode_entry(); 
      wait_ms(1);
      i2c.i2c_clear_spd_ctrl();
      wait_ms(1);
      i2c.i2c_set_comm_i_thres(0x0fff,1);  //note, 0fff is -1 signed
      wait_ms(1);
      i2c.i2c_set_comm_di_thres(0,1);
      wait_ms(1);
      i2c.i2c_set_fall_time_blank(4);
      wait_ms(1);
      i2c.i2c_set_50k_pwm(1);    
      wait_ms(1);        
      i2c.i2c_set_position_pulse_width(2,5); /*unsigned int mantisaa_2b, unsigned int exponent_3b*/
      wait_ms(1);
//    i2c.i2c_set_position_duty(3);
//    wait_ms(10);
//    i2c.i2c_set_position_anti_cog(0);
//    wait_ms(10);
//    i2c.i2c_set_start_up_duty(3);
//    wait_ms(10);
      i2c.i2c_set_start_up_pulse_width(3,5); /*(unsigned int mantisaa_3b, unsigned int exponent_3b*/
      wait_ms(1);
//    i2c.i2c_set_start_up_num_comm(3);
//    wait_ms(10);
//    //led4 = i2c.i2c_set_soft_start_up(1, 1, 0, 1, 1);
//    wait_ms(10);
//    i2c.i2c_clear_spd_ctrl();
      wait_ms(1);
      i2c.i2c_set_loop_mode(0);
      wait_ms(1);
      i2c.i2c_set_curve_type(3);
      wait_ms(1);
      i2c.i2c_set_dc_ini(2);
      wait_ms(1);
      i2c.i2c_set_dc_sr(0);
      wait_ms(1);
      i2c.i2c_set_rough_gain(0);
      wait_ms(1);
      i2c.i2c_set_ehp_reg_gain(0);
      wait_ms(1);
      i2c.i2c_set_clim_start_up(CLIM_LEVEL);
      wait_ms(1);
      i2c.i2c_set_clim_brake(CLIM_LEVEL);
      wait_ms(1);
      i2c.i2c_set_clim_run_time(CLIM_LEVEL);
      wait_ms(1);
      i2c.i2c_skip_app_copy();
      wait_ms(1);
      
      if(i2cRamDumpFlag == 1){
      /*dump calibration data start*/
        i2c.i2c_mlx_mode_entry();
        wait_ms(1);
        *(i2cBuffer+0) = (char)(I2C_STATUS)& 0xff;
        i2c.i2c_word_read(i2cBuffer);
        uart_print(i2cBuffer);
        
        if( i2cBuffer[2] == 0xC0 ){
            uart_I2C_test_pass();
            i2cTestPassFlag = 1;
            led4 = 0;
        }
        else {
            uart_I2C_test_fail();
            i2cTestPassFlag = 0;
            led4 = 1;
        }
        
        if(i2cTestPassFlag == 1){
            char i;
            for(i=0;i<=RAM_END_ADDR;i++) {
                *(i2cBuffer+0) = i;
                i2c.i2c_word_read(i2cBuffer);
                uart_print(i2cBuffer);
                wait_ms(300);
            }  
            uart_ram_dump_finish();
        }    
      }
      
      
      wait_ms(1);
      i2c.i2c_soft_reset();  
      wait_ms(40);
      i2c.i2c_set_open_loop_duty(0xffff);
    
    /*enter infinite loop, motor should be running*/
    while (1) {}

}