#include "mbed.h"
#include "CommandProcessor.h"
#include "prefs.h"

float __float_reg[64];
int __int_reg[64];

DigitalOut led(LED1);
InterruptIn in(PA_10);
PwmOut out(PA_8);

Serial pc(USBTX, USBRX);

char linebuf[128];
int index = 0;
void rxCallback() {
    while (pc.readable()) {
        char c = pc.getc();
        if (c != 127 && c != 8 && c != '\r' && c != '\t') {
            linebuf[index] = c;
            if (index < 127) index++;
            if (c < 128) pc.putc(c);
        } else if (c == 127 || c == 8) {
            if (index > 0) {
                index--;
                //BS (8) should delete previous char
                pc.putc(127);
            }
        } else if (c == '\r') {
            linebuf[index] = 0;
            if (index > 0) {
                pc.putc(c);
                processCmd(&pc, linebuf);
                pc.putc('>');
            } else {
                pc.putc(c);
                pc.putc('>');
            }
            index = 0;
        }
    }
}

void turn_on() {
    out.pulsewidth_us(_PULSE_WIDTH);
    led = 1;
}

void turn_off() {
    out.pulsewidth_us(0);
    led = 0;
}

int main() {
    pc.baud(115200);
    pc.attach(rxCallback);
    pc.printf("PYROFLEX\n");
    cmd_clear(&pc);
    cmd_defaults(&pc);
    pc.printf(">");
    
    out.period_us(10);
    out.pulsewidth_us(_PULSE_WIDTH);
    
    in.rise(turn_on);
    in.fall(turn_off);
    
    for (;;) {}
}
