#ifndef __COMMAND_PROCESSOR_H
#define __COMMAND_PROCESSOR_H

#include "mbed.h"

void processCmd(Serial *pc, char *buf);

/*---variable loading, setting, and flashing---*/
void cmd_ls(Serial *pc);
void cmd_ls2(Serial *pc, char *buf);
void cmd_set(Serial *pc, char *buf, char *val);
void cmd_defaults(Serial *pc);

/*---system commands---*/
void cmd_clear(Serial *pc);

/*---internal functions---*/
int tokenize(char *buf, char **out, int max);
float *checkf(char *s);
int *checkn(char *s);

#endif