#include "mbed.h"
#include "CommandProcessor.h"

#include "defaults.h"
#include "prefs.h"
#include "globals.h"

void cmd_ls(Serial *pc) {
    DPRINT(PULSE_WIDTH);
    DPRINT(PULSE_FREQ);
}

#define ls_specialf(a) if (strcmp(buf, #a) == 0) {pc->printf("%s: %f\n", #a, a); return;}
#define ls_speciald(a) if (strcmp(buf, #a) == 0) {pc->printf("%s: %d\n", #a, a); return;}
void cmd_ls2(Serial *pc, char *buf) {    
    float *fptr = checkf(buf);
    if (fptr != NULL) pc->printf("%s: %f\n", buf, *fptr);
    int *nptr = NULL;
    if (fptr == NULL) nptr = checkn(buf);
    if (nptr != NULL) pc->printf("%s: %d\n", buf, *nptr);
    if (nptr == NULL && fptr == NULL) pc->printf("%s\n", "No Such Parameter");
}

void cmd_defaults(Serial *pc) {
    DEFAULT(PULSE_WIDTH);
    DEFAULT(PULSE_FREQ);
    pc->printf("Defaults Loaded\n");
}

void cmd_set(Serial *pc, char *buf, char *val) {
    float *fptr = checkf(buf);
    if (fptr != NULL) *fptr = (float) (atof(val));
    int *nptr = NULL;
    if (fptr == NULL) nptr = checkn(buf);
    if (nptr != NULL) *nptr = (int) (atoi(val));
    if (nptr != NULL || fptr != NULL) cmd_ls2(pc, buf);
    if (nptr == NULL && fptr == NULL) pc->printf("%s\n", "No Such Parameter");
    
    if (strcmp(buf, "PULSE_FREQ") == 0) {
        out.period_us(1000 / _PULSE_FREQ);
    }
}