#include "mbed.h"
#include "CommandProcessor.h"

void processCmd(Serial *pc, char *buf) {
    char *tokens[10];
    int len = tokenize(buf, tokens, 10);
    
    switch (len) {
    case 1:
        if (strcmp(tokens[0], "ls") == 0) cmd_ls(pc);
        else if (strcmp(tokens[0], "defaults") == 0) cmd_defaults(pc);
        else if (strcmp(tokens[0], "clear") == 0) cmd_clear(pc);
        else pc->printf("%s\n", "Bad command");
        break;
    case 2:
        if (strcmp(tokens[0], "ls") == 0) cmd_ls2(pc, tokens[1]);
        else if (strcmp(tokens[0], "get") == 0) cmd_ls2(pc, tokens[1]);
        else pc->printf("%s\n", "Bad command");
        break;
    case 3:
        if (strcmp(tokens[0], "set") == 0) cmd_set(pc, tokens[1], tokens[2]);
        else pc->printf("%s\n", "Bad command");
        break;
    default:
        pc->printf("%s\n", "Bad command");
        break;
    }
}