#include "includes.h"
#include "core.h"
#include "meta.h"
#include "fastmath.h"
#include "transforms.h"

void SinusoidalModulator::Update(float valpha, float vbeta) {
    //--hack to make duty cycles positive
    float dtcA = valpha;
    float dtcB = ((-valpha + sqrt(3.0f) * vbeta) / 2.0f);
    float dtcC = ((-valpha - sqrt(3.0f) * vbeta) / 2.0f);
    _inverter->SetDtcA(dtcA * 0.5f + 0.5f);
    _inverter->SetDtcB(dtcB * 0.5f + 0.5f);
    _inverter->SetDtcC(dtcC * 0.5f + 0.5f);
}

void SvmModulator::Update(float valpha, float vbeta) {
    float va, vb;
    InverseClarke(valpha, vbeta, &va, &vb);
    
    float t1, t2, dtcA, dtcB, dtcC;
    
    /*
    //for positive dtheta/dt, t1 is decreasing.  t2 is increasing.
    if (va >= 0){  // (xx1)
        if (vb >= 0){ // (x11) 
            //300-360 degrees
            t1 = va;
            t2 = vb;
            dtcA = 0.5f - t1 / 2.0f;
            dtcB = 0.5f - t2 / 2.0f;
            dtcC = 1.5f - dtcA - dtcB;
        }
        else {  // (x01)
            if (vc >= 0){  // Sector 5: (1,0,1) 180-240 degrees
                t1 = va;
                t2 = vb;
                dtcA = 0.5f - t1 / 2.0f;
                dtcB = 0.5f - t2 / 2.0f;
                dtcC = 1.5f - dtcA - dtcB;
                               
            }
            else {// Sector 1: (0,0,1) 240-300 degrees
                t1 = va;
                t2 = vb;
                dtcA = 0.5f - t1 / 2.0f;
                dtcB = 0.5f - t2 / 2.0f;
                dtcC = 1.5f - dtcA - dtcB;
            }
        }
    } else { // (xx0)
        if (vb >= 0) { // (x10)
            if (vc >= 0) { // Sector 6: (1,1,0) 60-120 degrees
                t1 = va;
                t2 = vb;
                dtcA = 0.5f - t1 / 2.0f;
                dtcB = 0.5f - t2 / 2.0f;
                dtcC =  1.5f - dtcA - dtcB;
            }
            else {// Sector 2: (0,1,0) 0-60 degrees
                t1 = va;
                t2 = vb;
                dtcA = 0.5f - t1 / 2.0f;
                dtcB = 0.5f - t2 / 2.0f;
                dtcC = 1.5f - dtcA - dtcB;
            }
        }
        else { // (x00)
            // Must be Sector 4 since Sector 0 not allowed
            // Sector 4: (1,0,0) 120-180 degrees
            t1 = va;
            t2 = vb;
            dtcA = 0.5f - t1 / 2.0f;
            dtcB = 0.5f - t2 / 2.0f;
            dtcC = 1.5f - dtcA - dtcB;
        }
    }
    */
    
    t1 = va;
    t2 = vb;
    dtcA = 0.5f - t1 / 2.0f;
    dtcB = 0.5f - t2 / 2.0f;
    dtcC = 1.5f - dtcA - dtcB;

    _inverter->SetDtcA(dtcA);
    _inverter->SetDtcB(dtcB);
    _inverter->SetDtcC(dtcC);
    
    dbg_t1 = t1;
    dbg_t2 = t2;

    dbg_dtcA = dtcA;
    dbg_dtcB = dtcB;
    dbg_dtcC = dtcC;
}