#include "includes.h"
#include "fastmath.h"
#include "lut.h"

float FastMath::FastSin(float theta) {
    if (theta < 0.0f) theta += 360.0f;
    if (theta >= 360.0f) theta -= 360.0f;
    return 2.0f * sinetab[(int) theta] - 1.0f;
}

float FastMath::FastCos(float theta) {
    return FastSin(90.0f - theta);
}

float FastMath::FastSin01(float theta) {
    return FastSin(theta) * 0.5f + 0.5f;
}

float FastMath::FastCos01(float theta) {
    return FastCos(theta) * 0.5f + 0.5f;
}