#ifndef __FILTERS_H
#define __FILTERS_H

class LtiFilter {
public:
    virtual float Update(float x) {return x;}
};

class MeanFilter: public LtiFilter {
public:
    MeanFilter(float strength);
    virtual float Update(float x);
private:
    float _mean;
    float _strength;
};

class PidController {
public:
    PidController(float ki, float kp, float kd, float out_max = 1.0f, float out_min = 0.0f);
    float Update(float ref, float in);
private:
    float _ki, _kp, _kd;
    float _last_in, _integral;
    float _out_max, _out_min;
}; 
#endif