#include "includes.h"
#include "context.h"
#include "debug.h"

BufferedDebugger::BufferedDebugger(Context *context, int channels, int size) {
    _context = context;
    _size = size;
    _channels = channels;
    _index = (int*)malloc(_channels*sizeof(int));
    for (int i = 0; i < _channels; i++) _index[i] = 0;
    _done = 0;
    _buffer = (float*)malloc(_size * _channels * sizeof(float));
    _context->serial->printf("Debugger channels: %d\n\r", _channels);
    _context->serial->printf("Debugger depth: %d\n\r", _size);
}

void BufferedDebugger::Write(int channel, float f) {
    if (_index[channel] * _channels + channel < _size * _channels) {
        _buffer[_channels * _index[channel] + channel] = f;
        _index[channel]++;
    } else if (!_done) {
        Flush();
        _done = 1;
    }
}

void BufferedDebugger::Flush() {
    _context->inverter->Disable();
    _context->serial->printf("%s\n\r", "--Begin Debug log--");
    for (int i = 0; i < _size; i++) {
        for (int j = 0; j < _channels; j++) {
            _context->serial->printf("%f", _buffer[i * _channels + j]);
            if (j < _channels - 1) _context->serial->printf(", ");
        }
        _context->serial->printf("%\n\r");
    }
}

void BufferedDebugger::Restart() {
    _index = 0;
    _done = 0;
}
           