#include "includes.h"
#include "transforms.h"
#include "filters.h"
#include "context.h"
#include "core.h"
#include "meta.h"
#include "sensors.h"
#include "callbacks.h"

int main() { 
    Context *context = new Context();
    context->ConfigureOutputs(D6, D13, D3, D8);
    context->ConfigureCurrentSensors(A1, A2, 0.01f, 0.7f);
    context->ConfigureIdPidController(0.001f, 0.0f, 0.0f, 1.0f, -1.0f);
    context->ConfigureIqPidController(0.001f, 0.0f, 0.0f, 1.0f, -1.0f);
    context->ConfigureThrottle(A0, 0.8f, 3.0f);
    context->ConfigurePositionSensor(A4, A5, 0.249f, 0.497f, 0.231f, 0.499f, 205.0f);
    context->ConfigureReference(3.0f);  // max phase current
    context->ConfigureDebugger(2, 2000);
    context->AttachCallBack(&fast, 5000);
    context->AttachCallBack(&slow, 10);
    context->AttachCallBack(&debug, 10);
    context->AttachCallBack(&log, 500);
    context->Start();
}
