#ifndef __CONTEXT_H
#define __CONTEXT_H

#include "includes.h"
#include "transforms.h"
#include "filters.h"
#include "context.h"
#include "core.h"
#include "meta.h"
#include "sensors.h"

class BufferedDebugger;

class Context {
public:
    Context();
    void ConfigureOutputs(PinName oa, PinName ob, PinName oc, PinName en);
    void ConfigureCurrentSensors(PinName ib_pin, PinName ic_pin, float scale, float filter_strength);
    void ConfigureIdPidController(float ki, float kp, float kd, float pidmin, float pidmax);
    void ConfigureIqPidController(float ki, float kp, float kd, float pidmin, float pidmax);
    void ConfigureThrottle(PinName throttle_pin, float min, float max);
    void ConfigurePositionSensor(PinName pos_a_pin, PinName pos_b_pin, float cal1_a, float cal2_a, float cal1_b, float cal2_b, float offset);
    void ConfigureReference(float max_current);
    void ConfigureDebugger(int debugger_channels, int debugger_size);
    void AttachCallBack(void (*f)(Context *), int freq);
    void Start();
public:
    Inverter *inverter;
    Motor *motor;
    User *user;
    Throttle *throttle;
    CurrentSensor *sense_ib, *sense_ic;
    PositionSensor *sense_p;
    TempSensor *sense_t_motor, *sense_t_inverter;
    VoltageSensor *sense_bus;
    PidController *pid_d, *pid_q;
    Modulator *modulator;
    Serial *serial;
    ReferenceSynthesizer *reference;
    LtiFilter *filter_d, *filter_q;
    BufferedDebugger *debugger;
private:
    void InitData();
private:
    void upd_function();
private:
    PinName _oa, _ob, _oc, _ib_pin, _ic_pin, _throttle_pin, _pos_a_pin, _pos_b_pin, _en;
    float _dki, _dkp, _dkd, _qki, _qkp, _qkd, _min, _max, _cal1_a, _cal2_a, 
          _cal1_b, _cal2_b, _scale, _offset, _max_current, _filter_strength;
    int _debugger_channels, _debugger_size;
    float _dpidmax, _dpidmin, _qpidmax, _qpidmin;
    void (*_callbacks[16])(Context *);
    unsigned long  _call_times[16];
    int _call_periods[16];
    int _index;
    unsigned long _time;
    
    Ticker *_time_upd_ticker;
};
#endif