#include "includes.h"
#include "sensors.h"

Throttle::Throttle(PinName pin, float min, float max) {
    _in = new AnalogVoltageSensor(pin, 1.0f);
    _min = min;
    _max = max;
}

float Throttle::GetThrottle() {
    float v = _in->GetVoltage();
    v = (v - _min) / (_max - _min);
    if (v > 1.0f) return 1.0f;
    if (v < 0.0f) return 0.0f;
    return v;
}