#include "CommandProcessor.h"

#include "defaults.h"
#include "derived.h"
#include "globals.h"
#include "main.h"

char linebuf[128];
int index = 0;

void rxCallback() {
    while (io.pc->readable()) {
        char c = io.pc->getc();
        if (c != 127 && c != 8 && c != '\r' && c != '\t') {
            linebuf[index] = c;
            if (index < 127) index++;
            if (c < 128) io.pc->putc(c);
        } else if (c == 127 || c == 8) {
            if (index > 0) {
                index--;
                //BS (8) should delete previous char
                io.pc->putc(127);
            }
        } else if (c == '\r') {
            linebuf[index] = 0;
            if (!io.cmd_busy && linebuf[0] > 127) {
                processCmdFast(io.pc, io.pref, linebuf);
            } else if (!io.cmd_busy && index > 0) {
                io.pc->putc(c);
                processCmd(io.pc, io.pref, linebuf);
                io.pc->putc('>');
            } else {
                io.pc->putc(c);
                io.pc->putc('>');
            }
            index = 0;
        }
    }
}

extern "C" void TIM1_UP_TIM10_IRQHandler(void) {
    int start_state = io.throttle_in->state();
    
    if (TIM1->SR & TIM_SR_UIF ) {
        ADC1->CR2  |= 0x40000000; 
        volatile int delay;
        for (delay = 0; delay < 35; delay++);
        
        read.adval1 = ADC1->DR;
        read.adval2 = ADC2->DR;

        commutate();
    }
    TIM1->SR = 0x00;
    int end_state = io.throttle_in->state();
    if (start_state != end_state) io.throttle_in->block();
}

void update_velocity() {
    read.last_p_mech = read.p_mech;
    read.p_mech = io.pos->GetMechPosition();
    
    float dp_mech = read.p_mech - read.last_p_mech;
    if (dp_mech < -PI) dp_mech += 2 * PI;
    if (dp_mech >  PI) dp_mech -= 2 * PI;
    
    float w_raw = dp_mech * F_SW; //rad/s
    
    read.w = control.velocity_filter->update(w_raw);
}