#ifndef __THROTTLE_MAPPER_H
#define __THROTTLE_MAPPER_H

class ThrottleMapper {
public:
    virtual float map(float throttle, float w) = 0;
};

class NullThrottleMapper : public ThrottleMapper {
public:
    virtual float map(float throttle, float w) {if (throttle >= 0.0f) return throttle; return 0.0f;}
};

class InvertingThrottleMapper : public ThrottleMapper {
public:
    InvertingThrottleMapper(ThrottleMapper *m) {mapper = m;}
    virtual float map(float throttle, float w) {return -mapper->map(throttle,w);}
private:
    ThrottleMapper *mapper;
};

class DrivingThrottleMapper : public ThrottleMapper {
public:
    virtual float map(float throttle, float w);
private:
    float getMaxTqpctPlus(float w);
    float getMaxTqpctMinus(float w);
    float getZeroTqThrottle(float w);
};

class LimitingThrottleMapper : public ThrottleMapper {
public:
    LimitingThrottleMapper(float wmax);
    virtual float map(float throttle, float w);
private:
    float __wmax, __wlim;
};

class ConstantThrottleMapper : public ThrottleMapper {
public:
    ConstantThrottleMapper(float out) {__out = out;}
    virtual float map(float throttle, float w) {if (throttle > 0.01f) return __out; return 0.0f;}
private:
    float __out;
};

class AutoThrottleMapper : public ThrottleMapper {
public:
    AutoThrottleMapper(float rate, float period) {_rate = rate; _period = period; val = 0.0f;}
    virtual float map(float throttle, float w);
private:
    float _rate, _period;
    float val;
};

#endif