#include "PreferenceWriter.h"
#include "FlashWriter.h"

#include "prefs.h"

float __float_reg[64];
int __int_reg[64];

PreferenceWriter::PreferenceWriter(uint32_t sector) {
    writer = new FlashWriter(sector);
    __sector = sector;
    __ready = false;
}

void PreferenceWriter::open() {
    writer->open();
    __ready = true;
}

bool  PreferenceWriter::ready() {
    return __ready;
}

void PreferenceWriter::write(int x, int index) {
    __int_reg[index] = x;
}

void PreferenceWriter::write(float x, int index) {
    __float_reg[index] = x;
}

void PreferenceWriter::flush() {
    int offs;
    for (offs = 0; offs < 64; offs++) {
        writer->write(offs, __int_reg[offs]);
    }
    for (; offs < 128; offs++) {
        writer->write(offs, __float_reg[offs - 64]);
    }
    __ready = false;
}

void PreferenceWriter::load() {
    int offs;
    for (offs = 0; offs < 64; offs++) {
        __int_reg[offs] = flashReadInt(__sector, offs);
    }
    for(; offs < 128; offs++) {
        __float_reg[offs - 64] = flashReadFloat(__sector, offs);
    }
}

void PreferenceWriter::close() {
    __ready = false;
    writer->close();
}