#include "mbed.h"
#include "LedBlinker.h"

LedBlinker::LedBlinker(PinName p, float sample_frequency, float code_frequency) {
    _led = new DigitalOut(p);
    
    _tics_per_code = (int)(sample_frequency / code_frequency);
    _tics_per_bit = _tics_per_code / 8;
    
    _counter = 0;
    _code = 0;
    _bit = 0;
}

void LedBlinker::set_code(uint8_t code) {_code = code;}

void LedBlinker::update() {
    if (_counter % _tics_per_code == 0) {_counter = 0; _bit = 0;}
    _counter++;
    if (_counter % _tics_per_bit != 0) return;
    _led->write((_code & (1 << _bit)) >> _bit);
    _bit++;
}