#include "mbed.h"
#include "math.h"
#include "Filter.h"

MedianFilter::MedianFilter(int length) {
    buf = new fCircularBuffer(length, true);
}

float MedianFilter::update(float x) {
    buf->add(x);
    return buf->median();
}

MovingAverageFilter::MovingAverageFilter(int length) {
    buf = new fCircularBuffer(length, false);
}

float MovingAverageFilter::update(float x) {
    buf->add(x);
    return buf->mean();
}   