#include "mbed.h"
#include "CommandProcessor.h"
#include "PreferenceWriter.h"

#include "prefs.h"
#include "globals.h"

#include "hardware.h"
#include "defaults.h"
#include "derived.h"

#include "errors.h"
#include "Calibration.h"

void cmd_setp(Serial *pc, char *buf) {
    if (BREMS_src == CMD_SRC_TERMINAL) {
        float x = atof(buf);
        if (BREMS_op == OP_DRIVING && x < 0.0f) x = 0.0f;
        control.user_cmd = x;
        if (!checks_passed() && control.user_cmd != 0.0f) {
            pc->printf("%s\n", "Errors present, setting to 0.0");
            control.user_cmd = 0.0f;
        }
    }
}

void cmdf_setp(Serial *pc, char c) {
    if (BREMS_src == CMD_SRC_TERMINAL) {
        float x = (float)(c - 127) / 128.0f;
        if (BREMS_op == OP_DRIVING && x < 0.0f) x = 0.0f;
        control.user_cmd = x;
        if (!checks_passed() && control.user_cmd != 0.0f) {
            pc->printf("%s\n", "Errors present, setting to 0.0");
            control.user_cmd = 0.0f;
        }
    }
}

void cmd_mode(Serial *pc, char *buf) {
    if (control.user_cmd != 0.0f || control.torque_percent != 0.0f) {
        pc->printf("%s\n", "Turn off motor first");
        return;
    }
    int n = str_to_mode(buf);
    if (n < 0) {
        pc->printf("%s\n", "Invalid Mode");
        return;
    }
    BREMS_mode = n;
    
    //ZERO and CHR are special modes - they execute run-once functions
    //and override commutation, then exit to CFG
    if (BREMS_mode == MODE_ZERO) {
        calibrate_position(&io);
        control.user_cmd = 0.0f;
        BREMS_mode = MODE_CFG;
    }
    else if (BREMS_mode == MODE_CHR) {
        control.user_cmd = 0.0f;
        BREMS_mode = MODE_CFG;
    }
    else
    {
        pc->printf("Set mode to %s\n", mode_to_str(n));
    }
}

void cmd_src(Serial *pc, char *buf) {
    if (control.user_cmd != 0.0f || control.torque_percent != 0.0f) {
        pc->printf("%s\n", "Turn off motor first");
        return;
    }
    int n = str_to_src(buf);
    if (n < 0) {
        pc->printf("%s\n", "Invalid Source");
        return;
    }
    BREMS_src = n;
    pc->printf("Set source to %s\n", src_to_str(n));
}

void cmd_op(Serial *pc, char *buf) {
    if (control.user_cmd != 0.0f || control.torque_percent != 0.0f) {
        pc->printf("%s\n", "Turn off motor first");
        return;
    }
    int n = str_to_op(buf);
    if (n < 0) {
        pc->printf("%s\n", "Invalid operation");
        return;
    }
    BREMS_op = n;
    pc->printf("Set operation to %s\n", op_to_str(n));
}

void cmd_exit(Serial *pc) {
    if (control.user_cmd != 0.0f || control.torque_percent != 0.0f) {
        pc->printf("%s\n", "Turn off motor first");
        return;
    }
    BREMS_mode = MODE_RUN;
    pc->printf("%s\n", "Run mode ON");
}