/*
 *derived macros for the controller
 *don't change these unless you know what you're doing!
 */
 
#ifndef __DERIVED_H
#define __DERIVED_H

#include "hardware.h"
#include "prefs.h"

/*max modulation depth at which inverter is still linear*/
#define LINEAR_MODULATION_MAX (2.f * LINEAR_DTC_MAX - 1.f)

/*internally computed loop parameters*/
#define KP_D (_K_LOOP_D / _BUS_VOLTAGE / LINEAR_MODULATION_MAX)
#define KI_D (_KI_BASE_D * _K_LOOP_D / _BUS_VOLTAGE * 5000.0f / _F_SW / LINEAR_MODULATION_MAX)

#define KP_Q (_K_LOOP_Q / _BUS_VOLTAGE / LINEAR_MODULATION_MAX)
#define KI_Q (_KI_BASE_Q * _K_LOOP_Q / _BUS_VOLTAGE * 5000.0f / _F_SW / LINEAR_MODULATION_MAX)

#define KP_W (_K_LOOP_W)
#define KI_W (_KI_BASE_W * _K_LOOP_W * 5000.0f / _F_SW)

#define SLOW_LOOP_COUNTER ((int) (_F_SW / _F_SLOW_LOOP))

#endif