#ifndef __ERRORS_H
#define __ERRORS_H

#include "prefs.h"

#define _MASK_MODE_CFG (1 << (MODE_CFG))
#define _MASK_MODE_RUN (1 << (MODE_RUN))
#define _MASK_MODE_ZERO (1 << (MODE_ZERO))
#define _MASK_MODE_CHR (1 << (MODE_CHR))

#define _MASK_OP_TORQUE (1 << (NUM_MODES + OP_TORQUE))
#define _MASK_OP_DRIVING (1 << (NUM_MODES + OP_DRIVING))
#define _MASK_OP_SPEED (1 << (NUM_MODES + OP_SPEED))
#define _MASK_OP_POSITION (1 << (NUM_MODES + OP_POSITION))

#define _MASK_SRC_RC (1 << (NUM_MODES + NUM_OPS + CMD_SRC_RC))
#define _MASK_SRC_ANALOG (1 << (NUM_MODES + NUM_OPS + CMD_SRC_ANALOG))
#define _MASK_SRC_TERMINAL (1 << (NUM_MODES + NUM_OPS + CMD_SRC_TERMINAL))
#define _MASK_SRC_SERIAL (1 << (NUM_MODES + NUM_OPS + CMD_SRC_SERIAL))
#define _MASK_SRC_CAN (1 << (NUM_MODES + NUM_OPS + CMD_SRC_CAN))
#define _MASK_SRC_INTERNAL (1 << (NUM_MODES + NUM_OPS + CMD_SRC_INTERNAL))

#define _mask_mode(x) (1 << (x))
#define _mask_op(x) (1 << (NUM_MODES + x))
#define _mask_src(x) (1 << (NUM_MODES + NUM_OPS + x))

#define NUM_ERRORS 3
enum {
    ERR_THROTTLE_DISABLED,
    ERR_POS_INVALID,
    ERR_NOT_DRIVING,
};

extern int errors, moded_errors;
extern int masks[32];

void init_masks();
bool checks_passed();

#endif