#ifndef __DQ_MAPPER_H
#define __DQ_MAPPER_H

#include "tables.h"

class DQMapper {
public:
    virtual void map(float torque_percent, float w, float *d, float *q) = 0;
};

class QOnlyMapper : public DQMapper {
public:
    QOnlyMapper(float kt, float tmax) {_kt = kt; _tmax = tmax;}
    virtual void map(float torque_percent, float w, float *d, float *q) {*d = 0; *q = torque_percent * _tmax / _kt;}
private:
    float _kt;
    float _tmax;
};

class LinearNoFWMapper : public DQMapper {
public:
    LinearNoFWMapper(float kt, float tmax, float lambda) {_kt = kt; _tmax = tmax; _lambda = lambda;}
    virtual void map(float torque_percent, float w, float *d, float *q);
private:
    float _kt;
    float _tmax;
    float _lambda;
};

class LutMapper : public DQMapper {
public:
    virtual void map(float torque_percent, float w, float *d, float *q);
};

class InterpolatingLutMapper : public DQMapper {
public:
    virtual void map(float torque_percent, float w, float *d, float *q);
private:
    static float lookup(short table[][COLUMNS], int row, int col);
    static float lookup(short *table, int index);
    static float interp(float a, float b, float eps);
    static float interp(float a, float b, float c, float eps_row, float eps_col);
};

class AngleMapper : public DQMapper {
public:
    AngleMapper(float theta, float is) {_theta = theta; _is = is;}
    virtual void map(float torque_percent, float w, float *d, float *q);
private:
    float _is;
    float _theta;
};

class DirectMapper : public DQMapper {
public:
    DirectMapper(float id, float iq) {_id = id; _iq = iq;}
    virtual void map(float torque_percent, float w, float *d, float *q);
private:
    float _id, _iq;
};

class SwapMapper : public DQMapper {
public:
    SwapMapper(float id, float iq) {_id = id; _iq = iq;}
    virtual void map(float torque_percent, float w, float *d, float *q);
private:
    float _id, _iq;
};

class AutoMapper : public DQMapper {
public:
    AutoMapper(float phase_low, float phase_high, float steps, float is) 
        {_phase_low = phase_low; _phase_high = phase_high; _steps = steps; _is = is; _theta = _phase_low;}
    virtual void map(float torque_percent, float w, float *d, float *q);
private:
    float _phase_low, _phase_high, _steps,  _is;
    float _theta;
};

#endif