#include "mbed.h"
#include "CommandProcessor.h"
#include "PreferenceWriter.h"

#include "globals.h"
#include "hardware.h"
#include "defaults.h"
#include "derived.h"
#include "prefs.h"

int tokenize(char *buf, char **out, int max) {
    char* tok;
    int k = 0;
    
    tok = strtok(buf, " ");
    
    while(tok != NULL && k < max) {
        out[k] = tok;
        k++;
        tok = strtok(NULL, " ");
    }
    return k;
}

#define __check(x) if(strcmp(s, #x) == 0) return &_##x
#define __check2(x) if (strcmp(s, #x) == 0) return &x

float* checkf(char *s) {
    __check(MAX_TQPCT_PLUS);
    __check(MAX_TQPCT_MINUS);
    __check(TORQUE_MAX);
    __check(W_MAX);
    __check(BUS_VOLTAGE);
    __check(F_SW);
    __check(K_LOOP_D);
    __check(KI_BASE_D);
    __check(K_LOOP_Q);
    __check(KI_BASE_Q);
    __check(F_SLOW_LOOP);
    __check(INTEGRAL_MAX);
    __check(DQ_FILTER_STRENGTH);
    __check(POLE_PAIRS);
    __check(POS_OFFSET);
    __check(RESOLVER_LOBES);
    __check(Ld);
    __check(Lq);
    __check(FLUX_LINKAGE);
    __check(Rs);
    __check(KT);
    __check(W_SAFE);
    __check(W_CRAZY);
    __check(W_STEP);
    __check(OVERMODULATION_FACTOR);
    __check(V_PHASE_SWIZZLE);
    __check(K_LOOP_W);
    __check(KI_BASE_W);
    __check(W_SETPOINT_MAX);
    __check(W_LOOP_MAX_TQ);
    return NULL;
}

int* checkn(char *s) {
    __check(PREFS_VALID);
    __check(TORQUE_MODE);
    __check(CPR);
    __check(TH_LIMIT_LOW);
    __check(TH_LIMIT_HIGH);
    __check(W_FILTER_WINDOW);
    __check(THROTTLE_FILTER_WINDOW);
    __check(ENABLE_LOGGING);
    __check(LOG_PAGE_SIZE);
    __check(LOG_HEADER_SIZE);
    __check(LOG_PACKET_SIZE);
    __check(LOG_BAUD_RATE);
    __check2(BREMS_mode);
    __check2(BREMS_src);
    __check2(BREMS_op);
    return NULL;
}

#define __strcase(in, out) case in:strcpy(result, out);break
#define __intcase(in, out) if (strcmp(buf, in) == 0) return out

char* mode_to_str(int n) {
    static char result[12];
    switch (n) {
        __strcase(MODE_RUN, "Run");
        __strcase(MODE_CFG, "Config");
        __strcase(MODE_ZERO, "Zero");
        __strcase(MODE_CHR, "Wizard");
    default:
        strcpy(result, "Invalid");
        break;
    }
    return result;
}

int str_to_mode(char *buf) {
    __intcase("run", MODE_RUN);
    __intcase("cfg", MODE_CFG);
    __intcase("zero", MODE_ZERO);
    __intcase("char", MODE_CHR);
    __intcase("wizard", MODE_CHR);
    return -1;
}
 
char* src_to_str(int n) {
    static char result[12];
    switch (n) {
        __strcase(CMD_SRC_RC, "RC");
        __strcase(CMD_SRC_ANALOG, "Analog");
        __strcase(CMD_SRC_TERMINAL, "Terminal");
        __strcase(CMD_SRC_SERIAL, "Serial");
        __strcase(CMD_SRC_CAN, "CAN");
        __strcase(CMD_SRC_INTERNAL, "Internal");
    default:
        strcpy(result, "Invalid");
        break;
    }
    return result;
}

int str_to_src(char *buf) {
    __intcase("rc", CMD_SRC_RC);
    __intcase("analog", CMD_SRC_ANALOG);
    __intcase("terminal", CMD_SRC_TERMINAL);
    __intcase("serial", CMD_SRC_SERIAL);
    __intcase("can", CMD_SRC_CAN);
    __intcase("internal", CMD_SRC_INTERNAL);
    return -1;
}

char* op_to_str(int n) {
    static char result[24];
    switch(n) {
        __strcase(OP_TORQUE, "Torque loop");
        __strcase(OP_DRIVING, "Driving map");
        __strcase(OP_SPEED, "Speed loop");
        __strcase(OP_POSITION, "Position loop");
    default:
        strcpy(result, "Invalid");
        break;
    }
    return result;
}

int str_to_op(char *buf) {
    __intcase("torque", OP_TORQUE);
    __intcase("driving", OP_DRIVING);
    __intcase("speed", OP_SPEED);
    __intcase("pos", OP_POSITION);
    __intcase("position", OP_POSITION);
    return -1;
}
    