#ifndef __BUFFEREDLOGGER_H
#define __BUFFEREDLOGGER_H

#include "mbed.h"

class BufferedLogger {
public:
    BufferedLogger(int packet_size, int buffer_size, PinName tx, PinName rx, int rate);
    int log(float *pkt);
    int log(unsigned char *pkt);
    void flush();
    void enable() {_enabled = true;}
    void disable() {_enabled = false;}
private:
    int _packet_size, _buffer_size, _page_size, _index;
    unsigned char *_front, *_back, *_tmp, *_buf1, *_buf2;
    Serial *_log;
    
    bool _enabled;
};

unsigned char __clip(float x);
unsigned char __clip(unsigned char x);

#endif