#ifndef __CONFIG_H
#define __CONFIG_H

#include "mbed.h"

/*---programming flag---*/
#define _PREFS_VALID __int_reg[0]

/*---driving---*/
#define _TORQUE_MODE     __int_reg[1]
#define _MAX_TQPCT_PLUS  __float_reg[0]
#define _MAX_TQPCT_MINUS __float_reg[1]
#define _TORQUE_MAX      __float_reg[2]
#define _W_MAX           __float_reg[3]

/*---inverter---*/
#define _BUS_VOLTAGE     __float_reg[4]
#define _F_SW            __float_reg[5]

/*---loop---*/
#define _K_LOOP_D        __float_reg[6]
#define _KI_BASE_D       __float_reg[7]

#define _K_LOOP_Q        __float_reg[8]
#define _KI_BASE_Q       __float_reg[9]

#define _F_SLOW_LOOP     __float_reg[10]

#define _INTEGRAL_MAX    __float_reg[11]

#define _W_FILTER_WINDOW         __int_reg[2]
#define _DQ_FILTER_STRENGTH        __float_reg[12]
#define _THROTTLE_FILTER_WINDOW  __int_reg[3]

/*---motor---*/
#define _POLE_PAIRS      __float_reg[13]
#define _POS_OFFSET      __float_reg[14]
#define _RESOLVER_LOBES  __float_reg[15]
#define _CPR             __int_reg[4]
#define _Ld              __float_reg[16]
#define _Lq              __float_reg[17]
#define _FLUX_LINKAGE    __float_reg[18]
#define _Rs              __float_reg[19]
#define _KT              __float_reg[20]
#define _W_SAFE          __float_reg[21]
#define _W_CRAZY         __float_reg[22]

/*---rc_throttle---*/
#define _TH_LIMIT_LOW    __int_reg[5]
#define _TH_LIMIT_HIGH   __int_reg[6]

/*---table---*/
#define _W_STEP          __float_reg[23]

/*---data logging---*/
#define _ENABLE_LOGGING  __int_reg[7]
#define _LOG_PAGE_SIZE   __int_reg[8]
#define _LOG_HEADER_SIZE __int_reg[9]
#define _LOG_PACKET_SIZE __int_reg[10]
#define _LOG_BAUD_RATE   __int_reg[11]

/*---operating mode---*/

#define BREMS_mode             __int_reg[12]
#define BREMS_src              __int_reg[13]
#define BREMS_op               __int_reg[14]

/*---error handling---*/
#define ERR_ignores            __int_reg[15]

/*---commutation tweaks---*/
#define _OVERMODULATION_FACTOR __float_reg[24]
#define _V_PHASE_SWIZZLE       __float_reg[25]

/*---speed loop---*/
#define _K_LOOP_W __float_reg[26]
#define _KI_BASE_W __float_reg[27]
#define _W_SETPOINT_MAX __float_reg[28]
#define _W_LOOP_MAX_TQ __float_reg[29]

/*internal variables and macros*/

extern float __float_reg[];
extern int __int_reg[];

#define DEFAULT(a) _##a = a
#define FPRINT(a) pc->printf("%s: %f\n", #a, _##a)
#define DPRINT(a) pc->printf("%s: %d\n", #a, _##a)
#define FPRINT2(a) pc->printf("%s: %f\n", #a, a);
#define DPRINT2(a) pc->printf("%s: %d\n", #a, a)

#define NUM_MODES 4
enum {
    MODE_RUN,
    MODE_CFG,
    MODE_ZERO,
    MODE_CHR,
};

#define NUM_OPS 4
enum {
    OP_TORQUE,
    OP_DRIVING,
    OP_SPEED,
    OP_POSITION,
};

#define NUM_SRCS 6
enum {
    CMD_SRC_RC,
    CMD_SRC_ANALOG,
    CMD_SRC_TERMINAL,
    CMD_SRC_SERIAL,
    CMD_SRC_CAN,
    CMD_SRC_INTERNAL
};

#endif