#include "math.h"
#include "Transforms.h"

void clarke(float a, float b, float *alpha, float *beta) {
    *alpha = a;
    *beta = 1 / sqrtf(3.0f) * a + 2 / sqrtf(3.0f) * b;
}

void park(float alpha, float beta, float sin_p, float cos_p, float *d, float *q) {
    *d = alpha * cos_p + beta * sin_p;
    *q = -alpha * sin_p + beta * cos_p;
}

void invpark(float d, float q, float sin_p, float cos_p, float *alpha, float *beta) {
    *alpha = d * cos_p - q * sin_p;
    *beta = d * sin_p + q * cos_p;
}

void invclarke(float alpha, float beta, float *a, float *b) {
    *a = alpha;
    *b = -0.5f * alpha + sqrtf(3) / 2.0f * beta;
}
