#ifndef __PWMIN_H
#define __PWMIN_H

#include "mbed.h"

class PwmIn {
public:
    PwmIn(PinName pin, int usec_min, int usec_max);
    bool get_enabled();
    float get_throttle();
public:
    void block() {blocked = true;}
    int state() {return dig_in->read();}
    int get_usecs() {return usecs;}
private:
    void handle_rise();
    void handle_fall();
private:
    InterruptIn* int_in;
    DigitalIn*   dig_in;
    Timer timer;
    int usec_min, usec_max;
private:
    bool enabled;
    bool blocked;
    bool risen;
    int usecs;
};
#endif