#ifndef __POSITIONSENSOR_H
#define __POSITIONSENSOR_H

class PositionSensor {
public:
    virtual float GetMechPosition() {return 0.0f;}
    virtual float GetElecPosition() {return 0.0f;}
    virtual bool IsValid() {return false;}
};
  
class PositionSensorEncoder: public PositionSensor {
public:
    PositionSensorEncoder(int cpr, float offset);
    virtual float GetMechPosition();
    virtual float GetElecPosition();
    virtual bool IsValid();
private:
    InterruptIn *ZPulse;
    DigitalIn *ZSense;
    void ZeroEncoderCount(void);
    virtual float GetUnlimitedElecPosition();
private:
    int _cpr;
    int _lobes;
    float _offset;
    
    bool _valid;
    float _rotations;
};

#endif