#include "CurrentModel.h"

CurrentModel::CurrentModel(float Lr, float Rr, float fsw) {
    _tauinv = Rr / Lr;
    _tsw = 1.0f / fsw;
    
    _im = 0.0f;
    _theta = 0.0f;
}

float CurrentModel::getFluxPosition(float id, float iq, float w) {
    _im = _im + _tsw * _tauinv * (id - _im);
    float wf = w + _tauinv * iq / _im;
    _theta = _theta + _tsw * wf;
    return _theta;
}