#ifndef __CONFIG_PINS_H
#define __CONFIG_PINS_H

#define PWMA PA_8
#define PWMB PA_9
#define PWMC PA_10
#define EN PB_15

#define IA PA_4
#define IB PB_0

#define TH_PIN PB_8

#define TH_LIMIT_LOW 1100 //uS
#define TH_LIMIT_HIGH 1750
#define TH_LIMIT_CRAZY 2000

#define I_SCALE_RAW 25.0f //mv/A
#define R_UP 12000.0f //ohms
#define R_DOWN 3600.0f //ohms
#define R_BIAS 3600.0f //ohms
#define AVDD 3300.0f //mV

#define I_OFFSET (AVDD * R_DOWN * R_UP / (R_DOWN * R_UP + R_BIAS * (R_DOWN + R_UP)))
#define I_SCALE (R_BIAS * R_DOWN * I_SCALE_RAW / (R_DOWN * R_UP + R_BIAS * (R_DOWN + R_UP)))

#define set_dtc(phase, value) *phase = (value)

#endif