#include "mbed.h"
#include "CommandProcessor.h"
#include "PreferenceWriter.h"
#include "globals.h"

#include "config.h"
#include "config_driving.h"
#include "config_inverter.h"
#include "config_logging.h"
#include "config_loop.h"
#include "config_motor.h"
#include "config_pins.h"
#include "config_table.h"

void cmd_setp(Serial *pc, char *buf) {
    if (BREMS_src == CMD_SRC_TERMINAL) user_cmd = atof(buf);
}

void cmd_mode(Serial *pc, char *buf) {
    int n = str_to_mode(buf);
    if (n < 0) {
        pc->printf("%s\n", "Invalid Mode");
        return;
    }
    BREMS_mode = n;
    pc->printf("Set mode to %s\n", mode_to_str(n));
}

void cmd_src(Serial *pc, char *buf) {
    int n = str_to_src(buf);
    if (n < 0) {
        pc->printf("%s\n", "Invalid Source");
        return;
    }
    BREMS_src = n;
    pc->printf("Set source to %s\n", src_to_str(n));
}

void cmd_op(Serial *pc, char *buf) {
    int n = str_to_op(buf);
    if (n < 0) {
        pc->printf("%s\n", "Invalid Source");
        return;
    }
    BREMS_op = n;
    pc->printf("Set operation to %s\n", op_to_str(n));
}

void cmd_exit(Serial *pc) {
    BREMS_mode = MODE_RUN;
    pc->printf("%s\n", "Run mode ON");
}