#ifndef __COMMAND_PROCESSOR_H
#define __COMMAND_PROCESSOR_H

#include "mbed.h"
#include "PreferenceWriter.h"

void processCmd(Serial *pc, PreferenceWriter *pref, char *buf);

/*---variable loading, setting, and flashing---*/
void cmd_ls(Serial *pc);
void cmd_ls2(Serial *pc, char *buf);
void cmd_set(Serial *pc, char *buf, char *val);
void cmd_defaults(Serial *pc);
void cmd_reload(Serial *pc, PreferenceWriter *pref);
void cmd_flush(Serial *pc, PreferenceWriter *pref);

/*---mode switching---*/
void cmd_setp(Serial *pc, char *buf);
void cmd_mode(Serial *pc, char *buf);
void cmd_src(Serial *pc, char *buf);
void cmd_op(Serial *pc, char *buf);

/*---variable commands---*/
void cmd_exit(Serial *pc);

/*---internal functions---*/
int tokenize(char *buf, char **out, int max);
float *checkf(char *s);
int *checkn(char *s);
char *mode_to_str(int n);
int str_to_mode(char *buf);
char *src_to_str(int n);
int str_to_src(char *buf);
char *op_to_str(int n);
int str_to_op(char *buf);

#endif